#include "fmviporder.h"
#include "fmmsgwnd.h"
#include "fmcouponwidget.h"
#include "ui_fmviporder.h"
#include <QDebug>
#include <QScrollBar>

FMVipOrder::FMVipOrder(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipOrder)
{
    ui->setupUi(this);

    QString operator_id = FMVipForward::instance()->sessionData("operator_id");
    QString business_date = FMVipForward::instance()->sessionData("business_date");
    QString fm_id = FMVipForward::instance()->sessionData("fm_open_id");
    QString amount_str = FMVipForward::instance()->sessionData("amount");
    QString score_str = FMVipForward::instance()->sessionData("score");
    QString needPay_str = FMVipForward::instance()->sessionData("needPay");
    QString name = FMVipForward::instance()->sessionData("name");
    double standard_amount = FMVipForward::instance()->sessionDataInt("standard_amount") / 100.0;

    orderInfo = new FMVipOrder::OrderInfo(amount_str, score_str, needPay_str);
    orderInfo->setCouponMap(FMVipForward::instance()->sessionCouponMap());

    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);
    ui->id_label->setText(fm_id);
    ui->point_label->setText(score_str);
    ui->balance_label->setText(orderInfo->getAmountStr());
    ui->price_label->setText(orderInfo->getNeedPayStr());
    ui->name_label->setText(name);

    initCouponItems();
    connect(ui->coupon_page, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(onItemClicked(QListWidgetItem*)));

    ui->pay_chk->setText(QString("使用积分最多可抵用 %1 元").arg(orderInfo->getScoreAmount()));

    if(standard_amount > 0) {
        ui->standard_label->setText(QString("满 %1 元可享受储值金满额优惠").arg(standard_amount));
    }
    ui->pay_edit->setText(orderInfo->getNeedPayStr());
    ui->pay_edit->setFocus();

    ui->pay_edit->selectAll();
}

FMVipOrder::~FMVipOrder()
{
    if(orderInfo != NULL){
        delete orderInfo;
        orderInfo = NULL;
    }
    delete ui;
}

void FMVipOrder::on_pay_btn_clicked()
{
    FMVipForward::instance()->setSessionCouponMap(orderInfo->selectCouponMap);

    QString codeAmountStr = orderInfo->getPayAmountStr(ui->pay_edit->text());
    FMVipForward::instance()->addSessionData("codeAmount", codeAmountStr);

    ui->pay_btn->setEnabled(false);
    ui->pay_chk->setEnabled(false);

    emit doPost();
    setIsBusy(true);
}

void FMVipOrder::on_pay_chk_clicked(bool checked)
{
    int is = checked ? 1 : 0;
    FMVipForward::instance()->addSessionData("isUseScore", QString::number(is));
}

void FMVipOrder::onItemClicked(QListWidgetItem *item)
{
    QString code = item->data(Qt::UserRole).toString();

    // 如果代金券已被选中则取消，否则选中
    if(orderInfo->selectCouponMap.contains(code)) {
        ui->coupon_page->itemWidget(item)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-left: 5 solid rgb(255, 170, 37);}");
        orderInfo->selectCouponMap.remove(code);
    }else{
        ui->coupon_page->itemWidget(item)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-image: url(:/coupon_select.png);}");
        orderInfo->selectCouponMap[code] = orderInfo->couponMap()[code];
        if(orderInfo->enoughCoupon())
        {
            FMMsgWnd::WarningWnd("请注意代金券总额已超过待付金额！");
        }
    }
}

void FMVipOrder::initCouponItems()
{
    for(Coupon coupon : orderInfo->couponMap().values())
    {
        auto item = new QListWidgetItem();
        item->setData(Qt::UserRole, coupon.code);
        ui->coupon_page->addItem(item);
        ui->coupon_page->update();
        auto itemWidget = new FMCouponWidget(coupon);
        ui->coupon_page->setItemWidget(item, itemWidget);
        //item大小
        item->setSizeHint (itemWidget->size());
    }
}

void FMVipOrder::on_coupon_prev_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos - 125);
}

void FMVipOrder::on_coupon_next_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos + 125);
}
