#include "fmviplogin.h"
#include "ui_fmviplogin.h"
#include "fmvippanel.h"
#include <QFile>
#include <QJsonDocument>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include "fmvipforward.h"
#include "fmloading.h"

FMVipLogin::FMVipLogin(bool isMustPayCode, QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipLogin)
{
    ui->setupUi(this);

    QString operator_id = FMVipForward::instance()->sessionData("operator_id");
    QString business_date = FMVipForward::instance()->sessionData("business_date");


    ui->login_edit->setFocus();
    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);

    if(isMustPayCode)
    {
        ui->login_edit->setPlaceholderText("输入支付码");
    }else{
        ui->login_edit->setPlaceholderText("输入手机号/账号/支付码");
    }
}

FMVipLogin::~FMVipLogin()
{
    qDebug() << __FUNCTION__;
    delete ui;
}

void FMVipLogin::on_login_btn_clicked()
{
    qDebug() << __FUNCTION__;
    QString id = ui->login_edit->text();

    FMVipForward::instance()->addSessionData("code", id);

    ui->login_btn->setEnabled(false);
    ui->login_edit->setEnabled(false);

    emit doPost();
    setIsBusy(true);
}

void FMVipLogin::resetWnd()
{
    ui->login_btn->setEnabled(true);
    ui->login_edit->setEnabled(true);
    ui->login_edit->clear();
    ui->login_edit->setFocus();
}
