#include "fmvipfund.h"
#include "fmvipforward.h"
#include "ui_fmvipfund.h"
#include <QButtonGroup>

FMVipFund::FMVipFund(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipFund)
{
    ui->setupUi(this);
    QString operator_id = FMVipForward::instance()->sessionData("operator_id");
    QString business_date = FMVipForward::instance()->sessionData("business_date");
    QString fm_id = FMVipForward::instance()->sessionData("fm_open_id");
    QString amount_str = FMVipForward::instance()->sessionData("amount");
    QString charge_amount_str = FMVipForward::instance()->sessionData("charge_amount");
    QString name = FMVipForward::instance()->sessionData("name");

    double amount = amount_str.toDouble() / 100.0;
    double charge_amount = charge_amount_str.toDouble() / 100.0;

    QString show_amount_str = QString::number(amount, 'f', 2);
    QString show_charge_amount_str = QString::number(charge_amount, 'f', 2);

    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);
    ui->id_label->setText(fm_id);
    ui->balance_label->setText(show_amount_str);
    ui->amount_edit->setText(show_charge_amount_str);
    ui->name_label->setText(name);

    ui->fund_btn->setFocus();
}

FMVipFund::~FMVipFund()
{
    delete ui;
}

void FMVipFund::show()
{
    qDebug() << __FUNCTION__;

    FMVipWnd::show();
}

void FMVipFund::on_fund_btn_clicked()
{
    qDebug() << __FUNCTION__;
    double fundAmount = ui->amount_edit->text().toDouble() * 100;
    FMVipForward::instance()->addSessionData("fundAmount", QString::number(fundAmount));

    ui->fund_btn->setEnabled(false);

    emit doPost();
    setIsBusy(true);
}
