#include "fmsockserver.h"
#include "fmvipdispatcher.h"
#include "include/fmutils/fmutils.hpp"
#include <QApplication>
#include <QWidget>
#include "resend.h"
#include <QDebug>

bool checkOnly()
{
    HANDLE m_hMutex  =  CreateMutex(NULL, FALSE,  L"fm_vip" );

    if  (GetLastError()  ==  ERROR_ALREADY_EXISTS)  {
        CloseHandle(m_hMutex);
        m_hMutex  =  NULL;
        return  false;
    }
    else
        return true;
}

#if defined  Q_OS_LINUX   //for linux
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
bool checkOnly()
{
    const char filename[]  = "/tmp/lockfile_fm_vip";
    int fd = open (filename, O_WRONLY | O_CREAT , 0644);
    int flock = lockf(fd, F_TLOCK, 0 );
    if (fd == -1) {
        perror("open lockfile/n");
        return false;
    }
    //给文件加锁
    if (flock == -1) {
        perror("lock file error/n");
        return false;
    }
    //程序退出后，文件自动解锁
    return true;
}
#endif

void customMessageHandler(QtMsgType type,const QMessageLogContext& Context, const QString &msg)
{
    Q_UNUSED(Context);
    QString debugInfo;
    switch (type) {
    case QtDebugMsg:
        debugInfo = QString("Debug: %1").arg(msg);
        break;
    case QtWarningMsg:
        debugInfo = QString("Warning: %1").arg(msg);
        break;
    case QtCriticalMsg:
        debugInfo = QString("Critical: %1").arg(msg);
        break;
    case QtFatalMsg:
        debugInfo = QString("Fatal: %1").arg(msg);
        abort();
    }
    FMLOG("%s",debugInfo.toStdString().c_str());
}

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    if(checkOnly()==false)
        return 0;

    // 检查重发结算请求
    auto reSend = new ReSend();
    reSend->start();

    qInstallMessageHandler(customMessageHandler);

    FMVipDispatcher relay;
    FMSockServer server(&relay);

    server.Listen(23770);

    QWidget w;
    w.show();
    w.hide();

    return a.exec();
}
