#include "fmvippanel.h"
#include "fmvipforward.h"
#include "ui_fmvippanel.h"
#include "fmvipfund.h"

#include <QFile>


FMVipPanel::FMVipPanel(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipPanel)
{
    ui->setupUi(this);
    ui->coupon->setVisible(false);
}

FMVipPanel::~FMVipPanel()
{
    delete ui;
}

void FMVipPanel::show()
{
    ui->id_label->setText(_profile_obj["member_id"].toString());
    ui->name_label->setText(_profile_obj["member_name"].toString());
    ui->balance_label->setText(QString::number(_profile_obj["balance"].toInt()));
    ui->point_label->setText(QString::number(_profile_obj["points"].toInt()));
    ui->operator_label->setText(_profile_obj["operator_id"].toString());
    ui->bd_label->setText(_profile_obj["business_date"].toString());
    FMVipWnd::show();
}

void FMVipPanel::on_query_btn_clicked()
{
    qDebug() << __FUNCTION__;
}

void FMVipPanel::on_fund_btn_clicked()
{
    qDebug() << __FUNCTION__;
    FMVipFund *fund = new FMVipFund;
    QFile file(":/data/profile");
    if (file.open(QFile::ReadOnly)) {
        fund->setProfile(file.readAll());

        fund->show();
    }
    else {
        qDebug() << "Failed opening file: " << file.fileName();
    }
}

void FMVipPanel::on_new_btn_clicked()
{
    qDebug() << __FUNCTION__;
}

void FMVipPanel::on_lock_btn_clicked()
{
    qDebug() << __FUNCTION__;
}

void FMVipPanel::on_activate_btn_clicked()
{
    qDebug() << __FUNCTION__;
}

void FMVipPanel::on_delete_btn_clicked()
{
    qDebug() << __FUNCTION__;
}
