#ifndef FMVIPORDER_H
#define FMVIPORDER_H
#include <QListWidgetItem>
#include "fmvipwnd.h"
#include "fmvipforward.h"

#define MIN(a,b) ((a<b) ? a : b)
#define MAX(a,b) ((a<b) ? b : a)
#define DOUBLE_STR(num) QString::number(num, 'f', 2)

namespace Ui {
class FMVipOrder;
}

class FMVipOrder : public FMVipWnd
{
    Q_OBJECT

public:
    explicit FMVipOrder(QDialog *parent = 0);
    ~FMVipOrder();

    void setWillPayText();

public slots:
    void    on_pay_btn_clicked();
    void    on_pay_chk_clicked(bool checked);

    void    onItemClicked(QListWidgetItem*);

private slots:
    void on_coupon_prev_btn_clicked();

    void on_coupon_next_btn_clicked();

    void on_pay_edit_textChanged(const QString &text);

private:
    class OrderInfo
    {
    public:
        OrderInfo()
        {
            _amountStr = _scoreStr = _needPayStr = "";
            _amount = _score = _needPay = _maxWillPay = _useScore = _couponAmount = 0;
        }
        OrderInfo(QString amountStr, QString scoreStr, QString needPayStr)
        {
            this->_amountStr = amountStr;
            this->_scoreStr = scoreStr;
            this->_needPayStr = needPayStr;

            _amount = _amountStr.toInt() / 100.0;
            _score = (_scoreStr.toInt()/10) / 10.0;     // 不计分
            _needPay = _needPayStr.toInt() / 100.0;

            _maxWillPay = _useScore = _couponAmount = 0;
            setMaxWillPay();
        }

        QString getAmountStr()
        {
            return DOUBLE_STR(_amount);
        }

        QString getNeedPayStr()
        {
            return DOUBLE_STR(_needPay);
        }

        QString getScoreAmount()
        {
            return DOUBLE_STR(MIN(_score, _needPay));
        }

        QString getPayAmountStr(QString amountStr)
        {
            double payAmount = MIN(_needPay, (amountStr.toDouble() + _couponAmount + _useScore)) * 100;
            return QString::number(payAmount);
        }

        // 代金券总额超过待付时返回true
        bool enoughCoupon()
        {
            _couponAmount = 0.0;
            for(auto coupon : selectCouponMap)
            {
                _couponAmount += coupon.disAmount;
            }
            bool isEnough = (_couponAmount > _needPay);
            setMaxWillPay();
            return isEnough;
        }

        void setUseScore(bool isUse)
        {
            if(isUse) {
                _useScore = MIN(_score, _needPay);
            } else {
                _useScore = 0;
            }
            setMaxWillPay();
        }

        // 设置付款金额的最大值
        void setMaxWillPay()
        {
            double willPay = _needPay - _useScore - _couponAmount;
            _maxWillPay = MIN(MAX(willPay, 0), _amount);
        }
        double getMaxWillPay()
        {
            return _maxWillPay;
        }

        /// 代金券列表
        void setCouponMap(QMap<QString, Coupon> couponMap)
        {
            this->_couponMap = couponMap;

            _maxPage = (couponMap.count() - 1) / 6 + 1 ;
            _nowPage = -1;
        }

        QMap<QString, Coupon> couponMap()
        {
            return _couponMap;
        }
#if 0
        // 取得一个coupon map。默认为下一页
        QMap<QString, Coupon> getShowCouponMap(bool isNextPage = true)
        {
            if(isNextPage && _nowPage < _maxPage) {
                _nowPage ++;
            } else if(!isNextPage && _nowPage > 0) {
                _nowPage --;
            }
            int begin = _nowPage * 6;
            auto keys = _couponMap.keys();
            keys = keys.mid(begin, 6);

            QMap<QString, Coupon> showCouponMap;
            for(auto key : keys)
            {
                showCouponMap[key] = _couponMap[key];
            }
            return showCouponMap;
        }

        int maxPage()
        {
            return _maxPage + 1;
        }
        int nowPage()
        {
            return _nowPage + 1;
        }
#endif
        QMap<QString, Coupon> selectCouponMap;

    private:
        QString _amountStr, _scoreStr, _needPayStr;
        double _amount, _score, _needPay;
        QMap<QString, Coupon> _couponMap;
        int _maxPage, _nowPage;
        // 代金券金额    使用积分金额     余额将付金额
        double _couponAmount, _useScore, _maxWillPay;
    };

private:
    Ui::FMVipOrder *ui;

    FMVipOrder::OrderInfo *orderInfo;

    QString oldPayText;

    void initCouponItems();
};

#endif // FMVIPORDER_H
