#include "fmviporder.h"
#include "fmmsgwnd.h"
#include "fmcouponwidget.h"
#include "ui_fmviporder.h"
#include <QDebug>
#include <QScrollBar>

FMVipOrder::FMVipOrder(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipOrder)
{
    ui->setupUi(this);
    QString operator_id = SESSIONDATA_STRING("operator_id");
    QString business_date = SESSIONDATA_STRING("business_date");
    QString fm_id = SESSIONDATA_STRING("fm_open_id");
    QString amount_str = SESSIONDATA_STRING("amount");
    QString score_str = SESSIONDATA_STRING("score");
    QString needPay_str = SESSIONDATA_STRING("needPay");
    QString name = SESSIONDATA_STRING("name");
    QString birthday = SESSIONDATA_STRING("birthday");
    double standard_amount = SESSIONDATA_INT("standard_amount") / 100.0;

    orderInfo = new FMVipOrder::OrderInfo(amount_str, score_str, needPay_str);
    orderInfo->setCouponMap(SESSIONDATA_COUPONMAP("couponMap"));

    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);
    ui->id_label->setText(fm_id);
    ui->point_label->setText(score_str);
    ui->balance_label->setText(orderInfo->getAmountStr());
    ui->price_label->setText(orderInfo->getNeedPayStr());
    ui->name_label->setText(name);
    ui->bir_label->setText(birthday);

    initCouponItems();
    connect(ui->coupon_page, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(onItemClicked(QListWidgetItem*)));

    ui->pay_chk->setText(QString("使用积分抵用 %1 元").arg(orderInfo->getScoreAmount()));

    if(standard_amount > 0) {
        ui->standard_label->setText(QString("满 %1 元可享受储值金满额优惠").arg(standard_amount));
    } else {
        ui->standard_label->setText("");
    }

    oldPayText = DOUBLE_STR(orderInfo->getMaxWillPay());
    ui->pay_edit->setText(oldPayText);
    QRegExp regexp("^[0-9]+(.[0-9]{2})?$");
    ui->pay_edit->setValidator(new QRegExpValidator(regexp));
    setWillPayText();
}

FMVipOrder::~FMVipOrder()
{
    if(orderInfo != NULL){
        delete orderInfo;
        orderInfo = NULL;
    }
    delete ui;
}

void FMVipOrder::on_pay_btn_clicked()
{
    SESSIONDATA_ADD("payCouponMap", orderInfo->selectCouponMap);
    QString codeAmountStr = orderInfo->getPayAmountStr(ui->pay_edit->text());
    SESSIONDATA_ADD("codeAmount", codeAmountStr);

    ui->pay_btn->setEnabled(false);
    ui->pay_chk->setEnabled(false);

    setIsBusy(true);
    emit doPost();
}

void FMVipOrder::on_pay_chk_clicked(bool checked)
{
    int is = checked ? 1 : 0;
    SESSIONDATA_ADD("isUseScore", QString::number(is));
    orderInfo->setUseScore(checked);
    setWillPayText();
}

void FMVipOrder::onItemClicked(QListWidgetItem *item)
{
    QString code = item->data(Qt::UserRole).toString();

    // 如果代金券已被选中则取消，否则选中
    if(orderInfo->selectCouponMap.contains(code)) {
        ui->coupon_page->itemWidget(item)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-left: 5 solid rgb(255, 170, 37);}");
        orderInfo->selectCouponMap.remove(code);
        orderInfo->enoughCoupon();  // 计算一下当前代金券金额
    }else{
        ui->coupon_page->itemWidget(item)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-image: url(:/coupon_select.png);}");
        orderInfo->selectCouponMap[code] = orderInfo->couponMap()[code];
        if(orderInfo->enoughCoupon())
        {
            FMMsgWnd::WarningWnd("请注意代金券总额已超过待付金额！");
        }
    }
    setWillPayText();
}

void FMVipOrder::initCouponItems()
{
    for(Coupon coupon : orderInfo->couponMap().values())
    {
        auto item = new QListWidgetItem();
        item->setData(Qt::UserRole, coupon.code);
        ui->coupon_page->addItem(item);
        ui->coupon_page->update();
        auto itemWidget = new FMCouponWidget(coupon);
        ui->coupon_page->setItemWidget(item, itemWidget);
        //item大小
        item->setSizeHint (itemWidget->size());
    }
}

void FMVipOrder::setWillPayText()
{
    on_pay_edit_textChanged(oldPayText);

    ui->pay_edit->setFocus();
    ui->pay_edit->selectAll();
}

void FMVipOrder::on_coupon_prev_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos - 125);
}

void FMVipOrder::on_coupon_next_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos + 125);
}

void FMVipOrder::on_pay_edit_textChanged(const QString &text)
{
    double num = text.toDouble();
    double maxPay = orderInfo->getMaxWillPay();
    if (num > maxPay) {
        ui->pay_edit->setText(DOUBLE_STR(maxPay));

        QString maxPay_info = "余额只需支付 %1 元";
        if (maxPay >= orderInfo->getAmountStr().toDouble()) {
            maxPay_info = "余额最多支付 %1 元";
        }
        ui->pay_max->setText(maxPay_info.arg(maxPay));

        ui->pay_edit->setFocus();
        ui->pay_edit->selectAll();
    } else {
        oldPayText = text;
        ui->pay_max->setText("");
    }
}
