#include "fmviplogin.h"
#include "ui_fmviplogin.h"
#include "fmvippanel.h"
#include <QFile>
#include <QMutex>
#include "fmvipforward.h"
#include "fmloading.h"

FMVipLogin::FMVipLogin(bool isMustPayCode, QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipLogin)
{
    ui->setupUi(this);

    QString operator_id = SESSIONDATA_STRING("operator_id");
    QString business_date = SESSIONDATA_STRING("business_date");

    ui->login_edit->setFocus();
    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);

    QString version_info = getVersionInfo();
    ui->version_lable->setText(version_info);

    if(isMustPayCode)
    {
        ui->login_edit->setPlaceholderText("输入支付码");
    }else{
        ui->login_edit->setPlaceholderText("输入手机号/会员码/支付码");
    }
}

FMVipLogin::~FMVipLogin()
{
    delete ui;
}

QString FMVipLogin::getVersionInfo()
{
    QByteArray versionInfo;
    QFile versionFile(qApp->applicationDirPath() + "/version.dat");
    bool isOk = versionFile.open(QIODevice::ReadOnly);
    if(isOk) {
        versionInfo = versionFile.readAll();
    } else {
        versionInfo = "未知";
    }
    versionFile.close();
    return versionInfo;
}

void FMVipLogin::on_login_btn_clicked()
{
    qDebug() << __FUNCTION__;
    QString id = ui->login_edit->text();

    SESSIONDATA_ADD("code", id);

    ui->login_btn->setEnabled(false);
    ui->login_edit->setEnabled(false);

    setIsBusy(true);
    emit doPost();
}

void FMVipLogin::resetWnd()
{
    ui->login_btn->setEnabled(true);
    ui->login_edit->setEnabled(true);
    ui->login_edit->clear();
    ui->login_edit->setFocus();
}
