#include "fmvipfund.h"
#include "fmvipforward.h"
#include "ui_fmvipfund.h"

FMVipFund::FMVipFund(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipFund)
{
    ui->setupUi(this);
    QString operator_id = SESSIONDATA_STRING("operator_id");
    QString business_date = SESSIONDATA_STRING("business_date");
    QString fm_id = SESSIONDATA_STRING("fm_open_id");
    QString amount_str = SESSIONDATA_STRING("amount");
    QString charge_amount_str = SESSIONDATA_STRING("charge_amount");
    QString name = SESSIONDATA_STRING("name");
    QString birthday = SESSIONDATA_STRING("birthday");

    double amount = amount_str.toDouble() / 100.0;
    double charge_amount = charge_amount_str.toDouble() / 100.0;

    QString show_amount_str = QString::number(amount, 'f', 2);
    QString show_charge_amount_str = QString::number(charge_amount, 'f', 2);

    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);
    ui->id_label->setText(fm_id);
    ui->balance_label->setText(show_amount_str);
    ui->amount_edit->setText(show_charge_amount_str);
    ui->name_label->setText(name);
    ui->bir_label->setText(birthday);

    ui->fund_btn->setFocus();
}

FMVipFund::~FMVipFund()
{
    delete ui;
}

void FMVipFund::show()
{
    qDebug() << __FUNCTION__;

    FMVipWnd::show();
}

void FMVipFund::on_fund_btn_clicked()
{
    qDebug() << __FUNCTION__;
    double fundAmount = ui->amount_edit->text().toDouble() * 100;
    SESSIONDATA_ADD("fundAmount", QString::number(fundAmount));

    ui->fund_btn->setEnabled(false);

    setIsBusy(true);
    emit doPost();
}
