#ifndef FMVIPFORWARD_H
#define FMVIPFORWARD_H

#include "fmapicfg.h"
#include <QObject>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QJsonObject>

#define AppId           "T007"
#define KeyCode         "98d094a7-0d07-4cf5-b23b-d18783f0d76a"
#define PartnerId       "a8bee0dd-09d1-4fa9-a9eb-80cb36d3d611"
#define VersionInfo     "1.20"

#define Type_Login      "member_check_request"
#define Type_Coupon     "coupon_check_request"
#define Type_Pay        "order_request"
#define Type_Fund       "member_charge_request"
#define Type_Final      "integral_request"
#define Type_Order_Refund   "order_refund_request"
#define Type_Fund_Refund    "charge_refund_request"
#define Type_Order_Revoke   "order_revoke_request"

#define FM_VIP_LOGIN    1001
#define FM_VIP_FUND     1002
#define FM_VIP_PAY      1003
#define FM_VIP_REFUND   1004
#define FM_VIP_REVOKE   1005
#define FM_VIP_COUPON   1006
#define FM_VIP_FINAL    1007

struct Coupon
{
    QString code;
    double disAmount;
    QString desc;
};
Q_DECLARE_METATYPE(Coupon)      // 使Coupon类型可以和QVariant类型互相转换

#define SESSIONDATA(key)                FMVipForward::instance()->sessionData(key)
#define SESSIONDATA_STRING(key)         SESSIONDATA(key).toString()
#define SESSIONDATA_INT(key)            SESSIONDATA(key).toInt()
#define SESSIONDATA_JSONOBJECT(key)     SESSIONDATA(key).toJsonObject()
#define SESSIONDATA_MAP(key)            SESSIONDATA(key).toMap()
#define SESSIONDATA_COUPONMAP(key)      FMVipForward::instance()->getCouponMap(key)
#define SESSIONDATA_ADD(key, value)     FMVipForward::instance()->addSessionData(key, value)

class FMVipForward : public QObject
{
    Q_OBJECT
public:
    static FMVipForward* instance();
    ~FMVipForward();


    void parseRequest(const QJsonObject &jsonObj);

    void resetSessionData(const QJsonObject &jsonObj);
    QVariant sessionData(const QString key) const;
    void clearSessionData();
    void addSessionData(const QString key, const QVariant value);
    // 优惠券
    void addSessionData(const QString key, const QMap<QString, Coupon> couponMap);
    QMap<QString, Coupon> getCouponMap(const QString key);

    QString getString(int num) { return QString::number(num);}
    int getInt(QString num_str) {return num_str.toInt();}

private:
    FMVipForward(QObject *parent = 0);


    void login(const QJsonObject &job, QJsonObject &fmjob);
    void fund(const QJsonObject &job, QJsonObject &fmjob);
    void coupon(const QJsonObject &job, QJsonObject &fmjob);
    void pay(const QJsonObject &job, QJsonObject &fmjob);
    void final(const QJsonObject &job, QJsonObject &fmjob);
    // 销售单/充值单 退款
    void orderRefund(const QJsonObject &job, QJsonObject &fmjob);
    // 支付撤销
    void orderRevoke(const QJsonObject &job, QJsonObject &fmjob);

    void logined(const QJsonObject &serverJob, QJsonObject &posJob);
    void funded(const QJsonObject &serverJob, QJsonObject &posJob);
    void couponed(const QJsonObject &serverJob, QJsonObject &posJob);
    void payed(const QJsonObject &serverJob, QJsonObject &posJob);
    void finaled(const QJsonObject &serverJob, QJsonObject &posJob);
    // 销售单/充值单 退款
    void orderRefunded(const QJsonObject &serverJob, QJsonObject &posJob);
    // 支付撤销
    void orderRevoked(const QJsonObject &serverJob, QJsonObject &posJob);

    void request(const QJsonObject &reqJob);

    QString sign(const QJsonObject &reqJob) const;
private:
    static FMVipForward* _instance;

    FMApiCfg                _cfg;
    QNetworkRequest         _req;
    QString                 _urlStr;
    int                     _reqType;

    QMap<QString, QVariant>  _sessionDataMap;
    QStringList             _sessionDataList;

    QJsonObject             _needBackupReqJob;
signals:
    void                serverResponsed(const QJsonObject& rspData);
private slots:
    void                onServerFinished(QNetworkReply *reply, bool isTimeOut);
};

#endif // FMVIPFORWARD_H
