#ifndef FMVIPDISPATCHER_H
#define FMVIPDISPATCHER_H

#include <QObject>
#include <QJsonObject>
#include <QSystemTrayIcon>
#include "fmapirelay.h"
#include <QMutex>
#include <QWaitCondition>
#include <QTcpSocket>

#define Err_WindowClose "{\"statusCode\":1001, \"prompt\":0, \"msg\":\"fmv:窗口异常关闭\"}"
#define Err_ErrorFMCMD "{\"statusCode\":1002, \"prompt\":1, \"msg\":\"fmv:无法识别的请求类型\"}"
#define Err_Disconnected "{\"statusCode\":1003, \"prompt\":0, \"msg\":\"fmv:已经POS断开Socket连接\"}"

#define _DEBUG

class FMVipWnd;

class FMVipDispatcher : public QObject, public FMApiRelay
{
    Q_OBJECT
public:
    explicit            FMVipDispatcher(QObject *parent = 0);
    ~FMVipDispatcher();

private:
    void login();
    void pay();
    void coupon();
    void fund();
    void final();
    void orderRefund();
    void orderRevoke();
    BOOL isLogined();

protected:
    virtual INT         _ParseRequest(LPSTR data);
    virtual BOOL        _GetResponse(LPSTR &rsp, UINT &len);

signals:
    void                requested(const QJsonObject &);
    void                responded(const QByteArray &);
    void                startSocketTimer();
    void                stopSocketTimer();

private slots:
    void                onRequest(const QJsonObject &jsonObj);
    void                onResponse(const QByteArray &rsp);
    void                onFinished();

    void                onServerResponsed(const QJsonObject &rspObj);

    void                onDoPost();

    void                onCheckSocket();
    void                onDisconnected();

    void                onActiveSysTrayIcon(QSystemTrayIcon::ActivationReason);

    void                onQuit();
private:
    FMVipWnd           *_vindow;
    QJsonObject        _posReqObj;
    QByteArray         _serverRspData;
    BOOL               isLastOne;
    int                _windowReturn;

    QSystemTrayIcon    *_sysIcon;

    QTimer             *_posSocketTimer;

    QMutex              mutex;
    QWaitCondition      serverIsBusy;
    BOOL                requestSuccess;
    BOOL                isPayLogin;
    BOOL                isLogin;
};

#endif // FMVIPDISPATCHER_H
