#ifndef RESEND_H
#define RESEND_H

#include <QObject>
#include <QThread>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QMutex>
#include <QWaitCondition>

#define ID      0
#define URL     1
#define DATA    2

class FMApiCfg;

class ReSend : public QThread
{
    Q_OBJECT
public:
    ReSend();
    void trySend();
    ~ReSend();
signals:
    void doPost();
private slots:
    void onServerFinished(QNetworkReply *reply);
    void onDoPost();
protected:
    void run();
private:
    QNetworkAccessManager   *_nam;
    QNetworkRequest         _req;
    QByteArray              _data;
    QMutex                  mutex;
    QWaitCondition          waitCondition;

    bool                    isSuccess;
};

#endif // RESEND_H
