#include "resend.h"
#include "backup/fmbackup.h"
#include <QSqlQuery>
#include <QSqlRecord>
#include <QNetworkReply>
#include <QDebug>

ReSend::ReSend()
    :_nam(new QNetworkAccessManager(this))
{
    connect(this, SIGNAL(doPost()), this, SLOT(onDoPost()));
    connect(_nam, SIGNAL(finished(QNetworkReply*)), this, SLOT(onServerFinished(QNetworkReply*)));
}

ReSend::~ReSend()
{
    if(_nam != nullptr) {
        delete _nam;
        _nam = nullptr;
    }
}

void ReSend::trySend()
{
    QSqlRecord record;
    QSqlQuery reqDataQuery = FMBackup::instance()->reqDataQuery();
    while(reqDataQuery.next())
    {
        record = reqDataQuery.record();
        int id = record.value(ID).toInt();
        QString url = record.value(URL).toString();
        _data = record.value(DATA).toByteArray();

        _req.setUrl(url);
        _req.setHeader(QNetworkRequest::ContentTypeHeader, "application/json");
        _req.setHeader(QNetworkRequest::ContentLengthHeader, _data.length());

        mutex.lock();
        emit doPost();
        waitCondition.wait(&mutex);
        mutex.unlock();

        // 如果发送失败则不再继续发送
        if(!isSuccess) {
            break;
        } else {
            FMBackup::instance()->removeReqData(id);
        }
    }
}

void ReSend::run()
{
    while(true)
    {
        trySend();
        QThread::sleep(5);
    }
}

void ReSend::onDoPost()
{
    _nam->post(_req, _data);
}

void ReSend::onServerFinished(QNetworkReply *reply)
{
    if(reply->error() != QNetworkReply::NoError) {
        qDebug() << "重发时错误：" << reply->errorString();
        isSuccess = false;
    } else {
        qDebug() << "重发响应成功："<<  reply->readAll();
        isSuccess = true;
    }
    waitCondition.wakeAll();
}
