﻿#include "fm_mwrf32.h"
#include "mwdll/mwrf32.h"
#include <QCryptographicHash>
#include <QDebug>
#include <iostream>

#define OldSector 4

bool ConnectDevice(int port, int baud, int sector, const QString password, HANDLE &handle, QString &error)
{
    qDebug() << __FUNCTION__ << QString("port:%1,baud:%2,sector:%3,password:%4").arg(port).arg(baud).arg(sector).arg(password);

    int st;
    handle = rf_init(port, baud);
    if((int)handle<=0)
    {
        error = "open device failed";
        return false;
    }
    st = rf_load_key_hex(handle, 0, sector, password.toLatin1().data());
    qDebug() << "st: " << st << "pwd: " << password.toLatin1().data();
    if(st!=0)
    {
        rf_exit(handle);
        error = QString("load key error sector %1").arg(sector);
        return false;
    }
    rf_beep(handle,30);
    return true;
}

bool ReadCard(const HANDLE handle, int sector, QString &vipNo, QString& uuid, QString &error)
{
    int st;
    unsigned char rdata[17];
    // 寻卡
    unsigned long snr; //卡片序列号
    st = rf_card(handle, 0, &snr);
    if(st!=0)
    {
        error = "could not find the card";
        return false;
    }
    uuid = QString::number(snr);
    qDebug() << "uuid: " << uuid << "snr: " << snr;
    // 鉴权
    st = rf_authentication(handle, 0, sector);
    if(st!=0)
    {
        error = "check password failure";
        return false;
    }
    // 读卡号
    for(int i=0; i<2; ++i) {
        ZeroMemory(rdata,17);
        st = rf_read(handle, sector*4+i, rdata);

        qDebug() << "st: " << st<< "rdata: "<< (char*)rdata << QByteArray((char*)rdata).length();
        if(st!=0)
        {
            error = "read data error";
            return false;
        }

        vipNo += QByteArray((char*)rdata).trimmed();
    }
    // 读效验数据
//    QString keyData;
//    ZeroMemory(rdata,20);
//    st = rf_read(handle, sector*4+1, rdata);
//    if(st!=0)
//    {
//        error = "read key_data error";
//        return false;
//    }
//    keyData = QString::fromLatin1((char*)rdata);
//    // 对比数据
//    if(keyData.compare(QCryptographicHash::hash(QString("%1%2").arg(vipNo,MD5_KEY).toLatin1(), QCryptographicHash::Md5).toHex().mid(8, 16)))
//    {
//        error = "check key_data error";
//        return false;
//    }
    rf_halt(handle);
    rf_beep(handle,30);
    return true;
}

void DisConnectDevice(const HANDLE handle)
{
    rf_exit(handle);
}

bool ActivateCard(const HANDLE handle, int sector, const QString newPassword, QString &vipNo, QString& uuid, QString &error)
{
    int st;
    // 寻卡
    unsigned long snr; //卡片序列号
    st = rf_card(handle, 0, &snr);
    if(st!=0)
    {
        error = "could not find the card";
        return false;
    }
    uuid = QString::number(snr);
    // 从默认扇区读卡号
    // 鉴权
    st = rf_authentication(handle, 0, OldSector);
    if(st!=0)
    {
        error = "check password failure";
        return false;
    }
    // 读卡
    char rdata[32];
    ZeroMemory(rdata,32);
    st = rf_read_hex(handle, OldSector*4, rdata);
    if(st!=0)
    {
        error = "read default card no error";
        return false;
    }
    vipNo = QByteArray(rdata).mid(16);
    // 将卡号写入传入的扇区
    // 鉴权
    st = rf_authentication(handle, 0, sector);
    if(st!=0)
    {
        error = "check password failure";
        return false;
    }
    // 写入卡号
    qDebug() << "writeData: " << vipNo.toLatin1().toHex().mid(0,32);
    char* writeData = vipNo.toLatin1().toHex().mid(0,32).data();
    st = rf_write_hex(handle, sector*4, writeData);
    if(st!=0)
    {
        error = "write data failure";
        return false;
    }
    // 修改密码
    QByteArray tmpData = newPassword.toLatin1();
    unsigned char wkey[7];
    ZeroMemory(wkey, 7);
    a_hex(tmpData.data(), wkey, 12);
    st= rf_changeb3(handle, sector, wkey, 0, 0, 0, 1, 0, wkey);
    if(st!=0)
    {
        error = "change password error";
        return false;
    }
    qDebug() << "change password: " << tmpData;

    // 删除原扇区内容
    // 鉴权
    st = rf_authentication(handle, 0, OldSector);
    if(st!=0)
    {
        error = "check password failure";
        return false;
    }
    // 初始化为0
    st= rf_initval(handle, OldSector*4, 0);
    if(st!=0)
    {
        error = "initval error";
        return false;
    }
//    // 写入效验数据
//    QByteArray keyData = QCryptographicHash::hash(QString("%1%2").arg(vipNo,MD5_KEY).toLatin1(), QCryptographicHash::Md5);
//    st = rf_write(handle, sector*4+1, (unsigned char*)keyData.toHex().mid(8, 16).data());
//    if(st!=0)
//    {
//        error = "write data error";
//        return false;
//    }


    rf_halt(handle);
    rf_beep(handle,30);
    return true;
}

bool WriteCard(const HANDLE handle, int sector, QString data, QString &error)
{
    qDebug() << __FUNCTION__ << QString("sector:%1, data:%2").arg(sector).arg(data);

    int st;
    unsigned char rdata[17];
    // 寻卡
    unsigned long snr; //卡片序列号
    st = rf_card(handle, 0, &snr);
    if(st!=0)
    {
        error = "could not find the card";
        return false;
    }
    QString uuid = QString::number(snr);
    qDebug() << "uuid: " << uuid << "snr: " << snr;
    // 鉴权
    st = rf_authentication(handle, 0, sector);
    if(st!=0)
    {
        error = "check password failure";
        return false;
    }
    qDebug() << "writeData: " << data.toLatin1().toHex().mid(0,32);
    char* writeData = data.toLatin1().toHex().mid(0,32).data();
    st = rf_write_hex(handle, sector*4, writeData);
    if(st!=0)
    {
        error = "write data failure";
        return false;
    }

    rf_halt(handle);
    rf_beep(handle,30);
    return true;
}

bool LoadKeyHex(const HANDLE handle, int sector, QString password, QString &error)
{
    int st;
    st = rf_load_key_hex(handle, 0, sector, password.toLatin1().data());
    if(st!=0)
    {
        error = "Load key error";
        return false;
    }
    return true;
}
