﻿#include "fmvipsetting.h"
#include "ui_fmvipsetting.h"
#include "fmsetting.h"
#include "fmprinter.h"

FMVipSetting::FMVipSetting(FMVipWnd *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipSetting)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_TranslucentBackground);

    QStringList printerList = FMSetting::GetPrinterList();
    ui->printer_box->addItems(printerList);

    QString settingPrinterName = FMSetting::GetValue("Printer/name", "").toString();
    if(printerList.contains(settingPrinterName)) {
        ui->printer_box->setCurrentText(settingPrinterName);
    }
}

FMVipSetting::~FMVipSetting()
{
    delete ui;
}

void FMVipSetting::savePrinterName()
{
    FMSetting::SetValue("Printer/name", ui->printer_box->currentText());
}

void FMVipSetting::on_printer_btn_clicked()
{
    savePrinterName();
    FMPrinter::Print("FMVip打印测试\n\n\n\n\n\n");
}

void FMVipSetting::on_ok_btn_clicked()
{
    savePrinterName();
    this->close();
}
