﻿#include "taskmanage.h"
#include "fmvippanel.h"
#include "tasklogin.h"
#include "taskfund.h"
#include "taskothers.h"
#include "fmmsgwnd.h"
#include <QJsonDocument>
#include <QJsonObject>

TaskManage::TaskManage(QJsonObject &jsonObj, QObject *parent):
    FMTask(jsonObj, FM_Manage, 0, parent),
    childTask(nullptr)
{

}

TaskManage::~TaskManage()
{
    del_p(childTask);
}

QByteArray TaskManage::doTask()
{
    preTask = new TaskLogin(posReqJsonObj, _session, this);
    QByteArray loginRst = preTask->doTask();
    if(preTask->error() == FM_API_SUCCESS) {
        this->_session = preTask->session();
    } else {
        return loginRst;
    }
    return FMTask::doTask();
}

void TaskManage::setWindow()
{
    auto manageWindow = new FMVipPanel;

    connect(manageWindow, SIGNAL(fund()), this, SLOT(onFund()));
    _window = manageWindow;
}

void TaskManage::packagePOSRsp()
{
    if(childTask->error() != FM_API_SUCCESS) {
        this->setError(childTask->error(), childTask->errorString());
    } else {
        posRspJsonObj = *(childTask->getPosRspJsonObj());
    }
}

void TaskManage::onFund()
{
    childTask = new TaskFund(posReqJsonObj, this->session());
    doChildTask();
}

void TaskManage::doChildTask()
{
    childTask->doTask();

    auto childRsp = childTask->getPosRspJsonObj();
    for(QString prop : {PosProps.StatusCode, PosProps.Msg, PosProps.Prompt}) {
        posRspJsonObj[prop] = (*childRsp)[prop];
    }


    if(childTask->error() == FM_API_WINDOWCLOSE) {
        return;
    }
    closeWindow();
}

void TaskManage::stopTask()
{
    if(childTask != nullptr) {
        childTask->stopTask();
    }
    FMTask::stopTask();
}
