#include "fmhttpclient.h"
#include <tchar.h>
#include <string>

#pragma comment(lib, "winhttp.lib")


VOID        ToW(const char *src, LPWSTR wbuff)
{
    int str_size = MultiByteToWideChar(CP_ACP, 0, src, -1, NULL, 0);
    if (str_size > 0) {
        wchar_t *wurl = new wchar_t[str_size + 1];
        memset(wurl, 0, str_size + 1);
        MultiByteToWideChar(CP_ACP, 0, src, -1, wurl, str_size);
        delete[] wurl;
        if (wbuff) {

        }
    } else {
        FMLOG(TEXT("Invalid parameters when tries to convert %s to wide string"), src);
    }
}

LPCTSTR GetLastErrorMsg(DWORD dwError = 0) {
    static TCHAR buffer[1024] = { 0 };
    LPTSTR sys_buff = NULL;
    if (dwError == 0) {
        dwError = GetLastError();
    }
    FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
        FORMAT_MESSAGE_FROM_SYSTEM |
        FORMAT_MESSAGE_IGNORE_INSERTS,
        NULL,
        dwError,
        MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
        (LPTSTR)&sys_buff, 0, NULL);
    if (sys_buff) {
        memset(buffer, 0, sizeof(buffer));
        _tcscpy(buffer, sys_buff);
        LocalFree(sys_buff);
    }

    return buffer;
}

FMHttpClient::FMHttpClient( LPCWSTR url ) :
    _session(NULL),
    _connection(NULL),
    _request(NULL),
    _method(FMHTTP_GET),
    _port(80),
    _is_file(false)
{
    wcscpy(_version, L"HTTP/1.1");
    wcscpy(_method_get, L"GET");
    wcscpy(_method_post, L"POST");
    wcscpy(_method_put, L"PUT");
    wcscpy(_method_del, L"DELETE");

    _method_map[FMHTTP_GET] = _method_get;
    _method_map[FMHTTP_POST] = _method_post;
    _method_map[FMHTTP_PUT] = _method_put;
    _method_map[FMHTTP_DELETE] = _method_del;

    memset(_agent, 0, sizeof(_agent));
    memset(_headers, 0, sizeof(_headers));

#ifndef _UNICODE
    int str_size = MultiByteToWideChar(CP_ACP, 0, url, -1, NULL, 0);
    if (str_size > 0) {
        wchar_t *wurl = new wchar_t[str_size + 1];
        memset(wurl, 0, str_size + 1);
        MultiByteToWideChar(CP_ACP, 0, url, -1, wurl, str_size);
        _CrackUrl(wurl);

        delete[] wurl;
    } else {
        FMLOG(TEXT("Invalid parameters when tries to parse url %s, "), url);
    }
#else
    _CrackUrl((LPWSTR)url);
#endif
}

FMHttpClient::FMHttpClient( LPCSTR url ) :
    _session(NULL),
    _connection(NULL),
    _request(NULL),
    _method(FMHTTP_GET),
    _port(80),
    _is_file(false)
{
    wcscpy(_version, L"HTTP/1.1");
    wcscpy(_method_get, L"GET");
    wcscpy(_method_post, L"POST");
    wcscpy(_method_put, L"PUT");
    wcscpy(_method_del, L"DELETE");

    _method_map[FMHTTP_GET] = _method_get;
    _method_map[FMHTTP_POST] = _method_post;
    _method_map[FMHTTP_PUT] = _method_put;
    _method_map[FMHTTP_DELETE] = _method_del;

    memset(_agent, 0, sizeof(_agent));
    memset(_headers, 0, sizeof(_headers));

    int str_size = MultiByteToWideChar(CP_ACP, 0, url, -1, NULL, 0);
    if (str_size > 0) {
        wchar_t *wurl = new wchar_t[str_size + 1];
        memset(wurl, 0, str_size + 1);
        MultiByteToWideChar(CP_ACP, 0, url, -1, wurl, str_size);
        _CrackUrl(wurl);

        delete[] wurl;
    } else {
        FMLOG("Invalid parameters when tries to parse url %s, ", url);
    }
}


FMHttpClient::~FMHttpClient()
{
    if (_request) {
        WinHttpCloseHandle(_request);
        _request = NULL;
    }
    if (_connection) {
        WinHttpCloseHandle(_connection);
        _connection = NULL;
    }
    if (_session) {
        WinHttpCloseHandle(_session);
        _session = NULL;
    }
}


BOOL FMHttpClient::Send(LPVOID data, INT data_len, FMHttpMethod method)
{
    BOOL bRet = FALSE;

    _method = method;

    if (NULL != _Connect()) {
        bRet = _Request(data, data_len);
    }

    return bRet;
}


BOOL FMHttpClient::_CrackUrl( LPWSTR url )
{
    BOOL    bRet = FALSE;

    URL_COMPONENTS urlComp;
    ZeroMemory(&urlComp, sizeof(urlComp));
    urlComp.dwStructSize = sizeof(urlComp);
    urlComp.dwSchemeLength = (DWORD)-1;
    urlComp.dwHostNameLength = (DWORD)-1;
    urlComp.dwUrlPathLength = (DWORD)-1;
    urlComp.dwExtraInfoLength = (DWORD)-1;

    // Crack the URL.
    if (!WinHttpCrackUrl(url, (DWORD)wcslen(url), 0, &urlComp)) {
        FMLOG(TEXT("Failed parsing url \"%s\": %s"), url, GetLastErrorMsg());
    } else {
        bRet = TRUE;
    }

    memset(_server, 0, sizeof(_server));
    memset(_object, 0, sizeof(_object));

    LPWSTR str_pos = wcschr(urlComp.lpszHostName, ':');
    if (str_pos == NULL) {
        str_pos = wcschr(urlComp.lpszHostName, '/');
    }

    if (str_pos != NULL) {
       int server_len = str_pos - urlComp.lpszHostName;
       wcsncpy(_server, urlComp.lpszHostName, server_len);
    }
    else {
        wcscpy(_server, urlComp.lpszHostName);
    }

    wcscpy(_object, urlComp.lpszUrlPath);
    _port = urlComp.nPort;

    return bRet;
}


HINTERNET FMHttpClient::_Connect()
{
    // ȡỰ
    _session = WinHttpOpen(_agent, WINHTTP_ACCESS_TYPE_NO_PROXY, WINHTTP_NO_PROXY_NAME, WINHTTP_NO_PROXY_BYPASS, 0);
    if (_session == NULL) {
        FMLOG(TEXT("Failed to open http connection: %s"), GetLastErrorMsg());
    }

    // ȡӾ
    _connection = WinHttpConnect(_session, _server, _port, 0);
    if (_connection == NULL) {
        FMLOG(_T("Failed to connect server: %s"), GetLastErrorMsg());
    }

    return _connection;
}

BOOL FMHttpClient::_Request(LPVOID data, INT data_len)
{
    BOOL bRet = FALSE;
    // ȡ
    _request = WinHttpOpenRequest(_connection, _method_map[_method], _object, _version,
                                  WINHTTP_NO_REFERER, WINHTTP_DEFAULT_ACCEPT_TYPES, WINHTTP_FLAG_REFRESH);

    if (NULL == _request) {
        FMLOG(TEXT("Failed to open http request %s"), GetLastErrorMsg());
    } else {
        // 
        LPCWSTR headers = WINHTTP_NO_ADDITIONAL_HEADERS;
        if (wcslen(_headers) > 0) {
            headers = _headers;
        }

        if (data && data_len <= 0) {
            data_len = strlen((char*)data);
        }
        if (FALSE == WinHttpSendRequest(_request, headers, -1, WINHTTP_NO_REQUEST_DATA, 0, data_len, 0)) {
            FMLOG(TEXT("Failed to send request: %s"), GetLastErrorMsg());
        } else {
            bRet = TRUE;
            if (data_len > 0) {
                DWORD dwWriteSize = 0;
                if(FALSE == WinHttpWriteData(_request, data, data_len, &dwWriteSize)) {
                    FMLOG(TEXT("Failed to send http data: %s - %s"), GetLastErrorMsg(), data);
                    bRet = FALSE;
                }
            }
        }
    }

    return bRet;
}

const char*  FMHttpClient::Read()
{
    //  HTTP Ӧ
    if (FALSE == WinHttpReceiveResponse(_request, NULL)) {
        FMLOG(TEXT("Failed receiving response: %s"), GetLastErrorMsg());
        return NULL;
    }

    DWORD dwSize = 0;
    DWORD dwContentLen = 0;
    // ȡӦ Content-Type
    WinHttpQueryHeaders(_request, WINHTTP_QUERY_RAW_HEADERS_CRLF, WINHTTP_HEADER_NAME_BY_INDEX, NULL, &dwSize, WINHTTP_NO_HEADER_INDEX);
    if (GetLastError() == ERROR_INSUFFICIENT_BUFFER) {
        WCHAR *lpOutBuffer = new WCHAR[dwSize / sizeof(WCHAR)];

        if (FALSE == WinHttpQueryHeaders(_request,
            WINHTTP_QUERY_RAW_HEADERS_CRLF,
            WINHTTP_HEADER_NAME_BY_INDEX,
            lpOutBuffer, &dwSize,
            WINHTTP_NO_HEADER_INDEX)) {
                FMLOG(TEXT("Failed getting response header: %s"), GetLastErrorMsg());
        }

        LPCWSTR sHttpStatus = wcschr(lpOutBuffer, L' ');
        LPCWSTR sTmp = wcsstr(lpOutBuffer, L"Content-Type:");
        if (sTmp) {
            INT nLen = wcschr(sTmp, L'\r') - sTmp;
            wcsncpy(_content_type, sTmp, nLen);
        }
        swscanf(sHttpStatus, L"%d", &_status);

        WCHAR sContentLen[48] = { 0 };
        sTmp = wcsstr(lpOutBuffer, L"Content-Length:");
        if (sTmp) {
            INT nLen = wcschr(sTmp, L'\r') - sTmp;
            wcsncpy(sContentLen, sTmp, nLen);
            LPCWSTR sContentLenTmp = wcschr(sContentLen, L':') + 1;
            swscanf(sContentLenTmp, L"%ld", &dwContentLen);
        }

        delete[] lpOutBuffer;
    }

    if (_status == 200 || _status == 206) {
//         bRet = true;
    }

    // ѭ鲢ȡ
    DWORD dwDownloaded = 0, dwTotal = 0/*conn.offset*/, dwShowSize = dwTotal;
    LPSTR pszOutBuffer;
    do
    {
        // Ƿ
        dwSize = 0;
        if (!WinHttpQueryDataAvailable(_request, &dwSize)) {
            FMLOG(TEXT("Failed querying available data: %s"), GetLastErrorMsg());

            if (dwContentLen != dwTotal) {
//                 bRet = FALSE;
            }
            break;
        }

        if (dwSize <= 0) break;
        // ݿռ
        pszOutBuffer = new char[dwSize + 1];
        if (!pszOutBuffer) {
            FMLOG(TEXT("Out of memory"));
            dwSize = 0;
        }
        else {
            // ȡ
            ZeroMemory(pszOutBuffer, dwSize + 1);
            if (!WinHttpReadData(_request, (LPVOID)pszOutBuffer, dwSize, &dwDownloaded)) {
                FMLOG(TEXT("Failed reading response data: %s"), GetLastErrorMsg());
            }
            else {
                _response.Write(pszOutBuffer, dwSize);
#ifdef _UNICODE
                int str_size = MultiByteToWideChar(CP_ACP, 0, pszOutBuffer, -1, NULL, 0);
                if (str_size > 0) {
                    wchar_t *wbuff = new wchar_t[str_size + 1];
                    memset(wbuff, 0, str_size + 1);
                    MultiByteToWideChar(CP_ACP, 0, pszOutBuffer, -1, wbuff, str_size);
                    FMLOG(wbuff);
                    delete[] wbuff;
                }
#else
                FMLOG(pszOutBuffer);
#endif

                dwTotal += dwSize;
                if (dwTotal - dwShowSize > 1024 * 512) {
                    FMLOG(TEXT("Downloading process: %ld / %ld"), dwTotal, /*conn.offset + */dwContentLen);
                    dwShowSize = dwTotal;
                }
            }

            delete[] pszOutBuffer;
        }
    } while (dwSize > 0);

    return _response._buffer.c_str();
}

VOID FMHttpClient::_Save()
{
    FILE *fTarget = NULL;
    LPTSTR fileMode = NULL;
    // ļдģʽ
    BOOL bWriteBin = wcsstr(_content_type, L"application") != NULL;
    if (_status == 200 && bWriteBin) {
        fileMode = _T("wb");
    }
    else if (_status == 200 && !bWriteBin) {
        fileMode = _T("w");
    }
    else if (_status == 206 && bWriteBin) {
        fileMode = _T("ab");
    }
    else if (_status == 206 && !bWriteBin) {
        fileMode = _T("a");
    }

    if (_status == 200 || _status == 206) {
        fTarget = _tfopen(_filename, fileMode);
        fwrite(_response._buffer.c_str(), sizeof(char), _response._total_bytes, fTarget);
        fclose(fTarget);
    }
}

VOID FMHttpClient::SetHeaders(LPCWSTR headers)
{
    if (headers) {
        wcscpy(_headers, headers);
    }
}

LPCWSTR FMHttpClient::GetHeaders() const
{
    return _headers;
}

