﻿#ifndef FMVIP_H
#define FMVIP_H

#include "fmnetwork.h"
#include <QObject>

// 商家信息
#define APP_ID              "T008"
#define PARTNER_ID          "17ef7396-4c56-4e08-9f3f-5cba520234d6"
#define KEY_CODE            "ad124d4e-5f5a-450b-aa4b-902dfdb4631e"

class FMVip : public QObject
{
    Q_OBJECT

    enum MemberType {
        PayCode = 1,
        Phone,
        Account,
        EntityCard
    };

public:
    explicit FMVip(QObject *parent = 0);

    void login(const QString &vipNo, const QString &innerCode, QJsonObject &rspObj);
    void recharge(const QString &fm_open_id, int amount, QJsonObject &rspObj);
    void reversal(const QString &fmId);

private:
    void sendToServer(QJsonObject &reqObj, QJsonObject &rspObj);
    QString createTransId(const QString &storeId, const QString posId) const;
    MemberType memberType(const QString &vipNo) const;
    QString sign(const QJsonObject &reqJob) const;

    FMNetwork networker;
signals:

public slots:
};

#endif // FMVIP_H
