﻿#include "fmvippanel.h"
//#include "fmvipforward.h"
#include "ui_fmvippanel.h"
#include "fmvipfund.h"
#include "fmvipfund.h"

#include <QFile>


FMVipPanel::FMVipPanel(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipPanel)
{
    ui->setupUi(this);
}

FMVipPanel::~FMVipPanel()
{
    delete ui;
}

bool FMVipPanel::initWnd(Session *session)
{
    this->_session = session;
    ui->operator_label->setText(session->data(PosProps.OperatorId).toString());
    ui->bd_label->setText(session->data(PosProps.BussinessDate).toString());
    ui->id_label->setText(session->data(PosProps.Account).toString());
    ui->balance_label->setText(DOUBLE_STR(session->data(PosProps.Amount).toInt() / 100.0));
    ui->name_label->setText(session->data(PosProps.Name).toString());
    ui->bir_label->setText(session->data(PosProps.Birthday).toString());
    ui->point_label->setText(QString::number(session->data(PosProps.Score).toInt()));

    int isActived = session->data(PosProps.IsActive).toInt();
    if(isActived == 0) {
        ui->fund_btn->setStyleSheet("#fund_btn { background: rgb(166,166,166);}");
        ui->fund_btn->setEnabled(false);
    }

    ui->fund_btn->setFocus();
    return true;
}

void FMVipPanel::on_fund_btn_clicked()
{
    emit fund();
}
