﻿#include "fmviporder.h"
#include "fmmsgwnd.h"
#include "ui_fmviporder.h"
#include "fmnumpad.h"
#include "itemdelegate.h"
#include "couponmodel.h"
#include <QScrollBar>
#include <QItemSelectionModel>

FMVipOrder::FMVipOrder(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipOrder)
{
    numpad = NULL;
    ui->setupUi(this);
}

FMVipOrder::~FMVipOrder()
{
    del_p(orderInfo);
    if(numpad != NULL)
    {
        delete numpad;
        numpad = NULL;
    }
    delete ui;
}

bool FMVipOrder::initWnd(Session *session)
{
    this->_session = session;

    QString operator_id = session->data(PosProps.OperatorId).toString();
    QString business_date = session->data(PosProps.BussinessDate).toString();
    QString fm_id = session->data(PosProps.Account).toString();
    QString name = session->data(PosProps.Name).toString();
    QString birthday = session->data(PosProps.Birthday).toString();

    QString amount_str = QString::number(session->data(PosProps.Amount).toInt());
    QString score_str = QString::number(session->data(PosProps.Score).toInt());

    int orderAmount = session->data(PosProps.OrderAmount).toInt();
    int needPay = orderAmount - session->data(PosProps.PaidAmount).toInt();
    QString needPay_str = QString::number(needPay);
    double standard_amount = session->data(PosProps.StandardAmount).toInt() / 100.0;

    int socre_value = session->data(PosProps.Score_value).toInt();
    orderInfo = new FMVipOrder::OrderInfo(amount_str, socre_value, needPay_str);
    double maxDisAmount = (orderAmount - session->data(PosProps.UndisAmount).toInt()) / 100.0;
    orderInfo->setMaxDisAmount(maxDisAmount);

    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);
    ui->id_label->setText(fm_id);
    ui->point_label->setText(score_str);
    ui->balance_label->setText(orderInfo->getAmountStr());
    ui->price_label->setText(orderInfo->getNeedPayStr());
    ui->name_label->setText(name);
    ui->bir_label->setText(birthday);

    couponModel = new CouponModel(this);
    ui->coupon_page->setModel(couponModel);
    ItemDelegate *delegate = new ItemDelegate(this);
    ui->coupon_page->setItemDelegate(delegate);
    selectionModel = ui->coupon_page->selectionModel();
    connect(selectionModel, &QItemSelectionModel::selectionChanged, this, &FMVipOrder::onSelectionChanged);

    initCouponItems();

//    ui->pay_chk->setText(QString("使用积分抵用 %1 元").arg(orderInfo->getScoreAmount()));

    if(standard_amount > 0) {
        ui->standard_label->setText(QString("满 %1 元可享受储值金满额优惠").arg(standard_amount));
    } else {
        ui->standard_label->setText("");
    }

    oldPayText = DOUBLE_STR(orderInfo->getMaxWillPay());
    ui->pay_edit->setText(oldPayText);
    QRegExp regexp("^[0-9]+(.[0-9]{2})?$");
    ui->pay_edit->setValidator(new QRegExpValidator(regexp));
    setWillPayText();
    return true;
}

void FMVipOrder::on_pay_btn_clicked()
{
    session()->addData(PosProps.CouponMap, orderInfo->selectCouponMap);
    QString codeAmountStr = orderInfo->getPayAmountStr(ui->pay_edit->text());
    session()->addData(PosProps.CodeAmount, codeAmountStr.toInt());

    this->setEnabled(false);

    setIsBusy(true);

    emit pay();
}

//void FMVipOrder::on_pay_chk_clicked(bool checked)
//{
//    int is = checked ? 1 : 0;
//    session()->addData(ServerProps(PosProps.IsUseScore), is);
//    orderInfo->setUseScore(checked);
//    setWillPayText();
//}


//! 点击元素时选中/取消选中代金券
void FMVipOrder::on_coupon_page_clicked(const QModelIndex &index)
{
    // 如果选中状态则取消选中
    if(selectionModel->isSelected(index)) {
        selectionModel->select(index, QItemSelectionModel::Deselect);
    } else {
        // 如果已经有一个选中的，则判断选中的这个是否是不可叠加券
        if(selectionModel->selectedIndexes().length() == 1) {
            QModelIndex firstIndex = selectionModel->selectedIndexes().first();
            if(!couponModel->coupon(firstIndex).isCompatible()) {
                FMMsgWnd::FailureWnd("已经选中了一张不可叠加券，不能再选用其他代金券");
                return;
            }
        }
        Coupon coupon = couponModel->coupon(index);
        // 判断是否满足使用条件
        if(orderInfo->getMaxDisAmount() < coupon.limitAmount()) {
            FMMsgWnd::FailureWnd("该代金券不满足使用条件");
            return;
        }
        // 处理不可叠加券
        if(!coupon.isCompatible()) {
            if(!selectionModel->selectedIndexes().isEmpty()) {
                FMMsgWnd::FailureWnd("该代金券不可与其他代金券叠加使用，请取消选中其他代金券");
                return;
            }
            selectionModel->select(index, QItemSelectionModel::ClearAndSelect);
        } else {
            selectionModel->select(index, QItemSelectionModel::Select);
        }
    }
}


void FMVipOrder::initCouponItems()
{
    orderInfo->setCouponMap(_session->getCouponMap(PosProps.CouponMap));

    for(Coupon coupon : orderInfo->couponMap().values())
    {
        couponModel->push_back(coupon);
    }

    ui->pay_edit->setFocus();
    ui->pay_edit->selectAll();
}

void FMVipOrder::onSelectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
{
    foreach (QModelIndex index, selected.indexes()) {
        Coupon coupon = couponModel->coupon(index);
        orderInfo->selectCouponMap[coupon.code()] = orderInfo->couponMap()[coupon.code()];
        orderInfo->setMaxDisAmount(orderInfo->getMaxDisAmount() - coupon.limitAmount());
    }
    foreach (QModelIndex index, deselected.indexes()) {
        Coupon coupon = couponModel->coupon(index);
        orderInfo->selectCouponMap.remove(coupon.code());
        orderInfo->setMaxDisAmount(orderInfo->getMaxDisAmount() + coupon.limitAmount());
    }
    orderInfo->enoughCoupon();
    setWillPayText();
}

void FMVipOrder::setWillPayText()
{
    on_pay_edit_textChanged(oldPayText);

    ui->pay_edit->setFocus();
    ui->pay_edit->selectAll();
}

void FMVipOrder::on_coupon_prev_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos - 125);
}

void FMVipOrder::on_coupon_next_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos + 125);
}

void FMVipOrder::on_pay_edit_textChanged(const QString &text)
{
    double num = text.toDouble();
    double maxPay = orderInfo->getMaxWillPay();
    if (num > maxPay) {
        ui->pay_edit->setText(DOUBLE_STR(maxPay));

        QString maxPay_info = "余额只需支付 %1 元";
        if (maxPay >= orderInfo->getAmountStr().toDouble()) {
            maxPay_info = "余额最多支付 %1 元";
        }
        ui->pay_max->setText(maxPay_info.arg(maxPay));

        ui->pay_edit->setFocus();
        ui->pay_edit->selectAll();
    } else {
        oldPayText = text;
        ui->pay_max->setText("");
    }
}

void FMVipOrder::on_pay_key_clicked()
{
    if(numpad == NULL)
    {
        numpad = new FMNumPad(this);
        connect(numpad, &FMNumPad::finished, this, &FMVipOrder::on_clean_numpad);
        connect(numpad, &FMNumPad::digit_click, this, &FMVipOrder::on_edit_change);
        connect(numpad, &FMNumPad::digit_delete, this, &FMVipOrder::on_delete_clicked);
        connect(numpad, &FMNumPad::digit_clear, this, &FMVipOrder::on_clear_clicked);
        connect(numpad, &FMNumPad::digit_confirm, this, &FMVipOrder::on_confirm_clicked);
        numpad->show();
        numpad->setGeometry(x() + width()/2-20, numpad->y()+100, numpad->width(), numpad->height());
    } else {
        numpad->close();
        delete numpad;
        numpad = NULL;
    }
}

void FMVipOrder::on_clean_numpad()
{
    if(numpad != NULL)
    {
        delete numpad;
        numpad = NULL;
    }
}

void FMVipOrder::on_edit_change(QString numkey)
{
     ui->pay_edit->setText(ui->pay_edit->text() + numkey);
}

void FMVipOrder::on_delete_clicked()
{
    int length = ui->pay_edit->text().size();
    if(length <= 1)
        ui->pay_edit->setText(QString(""));
    else
        ui->pay_edit->setText(ui->pay_edit->text().left(length - 1));
}

void FMVipOrder::on_clear_clicked()
{
    ui->pay_edit->setText(QString(""));
}
void FMVipOrder::on_confirm_clicked()
{
    on_pay_btn_clicked();
}
