﻿#ifndef TASKPAY_H
#define TASKPAY_H
#include "fmtask.h"
#include <QThread>
#include "taskothers.h"

class TaskCouponThread;

class TaskPay : public FMTask
{
    Q_OBJECT
public:
    explicit TaskPay(QJsonObject &jsonObj, QObject* parent=0);
    ~TaskPay();

    QByteArray doTask();
    void setWindow();
    void packageServerReq();
    void packagePOSRsp();

private slots:
    void onPay();
    void onGetCoupons(Session *session);

private:
    TaskCouponThread *couponThread;
};

// 加载代金券的线程类
class TaskCouponThread : public QThread
{
    Q_OBJECT
public:
    TaskCouponThread(QJsonObject &jsonObj, Session *session, QObject *parent = 0) {
        _session = session;
        task = new TaskCoupon(jsonObj, session, parent);
    }
    ~TaskCouponThread() {
        del_p(task);
    }

    void run() {
        task->doTask();
        emit finished(_session);
    }

    TaskCoupon *task;
    Session *_session;
signals:
    void finished(Session*);
};

#endif // TASKPAY_H
