﻿#include "fmprinter.h"
#include "fmsetting.h"
#include <windows.h>
#include <winspool.h>
#include <QPrinterInfo>
#include <QMessageBox>
#include <QDebug>
#include "fmvipsetting.h"

FMPrinter::FMPrinter(QObject *parent) : QObject(parent)
{

}

bool FMPrinter::Print(QString data)
{
    QString printerName = FMSetting::GetValue("Printer/name", "").toString();
    if(printerName == "") {
        printerName = FMSetting::GetPrinterList().first();
        FMSetting::SetValue("Printer/name", printerName);
//        FMVipSetting settingPrinterWnd;
//        settingPrinterWnd.exec();
    }
    qDebug() << "打印机名称: " << printerName;
    char *str = printerName.toLocal8Bit().data();
    int length = strlen(str)+1;
    wchar_t *wStr = (wchar_t*)malloc(sizeof(wchar_t)*length);
    memset(wStr,0,length*sizeof(wchar_t));
    MultiByteToWideChar(CP_ACP,0,str,strlen(str),wStr,length);
    LPTSTR szPrinterName = (LPTSTR)wStr;
    QByteArray tmpData = data.toLocal8Bit();
    LPBYTE lpData=(LPBYTE)tmpData.data();
    DWORD dwCount = strlen((char*)lpData);
    BOOL     bStatus = FALSE;
    HANDLE     hPrinter = NULL;
    DOC_INFO_1 DocInfo;
    DWORD      dwJob = 0L;
    DWORD      dwBytesWritten = 0L;

    // Open a handle to the printer.

    bStatus = OpenPrinter( szPrinterName, &hPrinter, NULL );

    if (bStatus) {
        // Fill in the structure with info about this "document."

        DocInfo.pDocName = (LPTSTR)L"TakeawayDoc";

        DocInfo.pOutputFile = NULL;
        DocInfo.pDatatype = (LPTSTR)L"RAW";

        // Inform the spooler the document is beginning.

        dwJob = StartDocPrinter( hPrinter, 1, (LPBYTE)&DocInfo );

        if (dwJob > 0) {
            // Start a page.

            bStatus = StartPagePrinter( hPrinter );

            if (bStatus) {
                // Send the data to the printer.

                bStatus = WritePrinter( hPrinter, lpData, dwCount, &dwBytesWritten);

                EndPagePrinter (hPrinter);
            }
            // Inform the spooler that the document is ending.

            EndDocPrinter( hPrinter );

        }
        // Close the printer handle.

        ClosePrinter( hPrinter );

    }
    // Check to see if correct number of bytes were written.

    if (!bStatus || (dwBytesWritten != dwCount)) {
        bStatus = FALSE;
        qDebug() << "打印错误代码：" << GetLastError();
        qDebug() << "打印数据" << data;
    } else {
        bStatus = TRUE;
    }
    return bStatus;
}
