﻿#include "rechargewnd.h"
#include "ui_rechargewnd.h"
#include "fmsetting.h"
#include "cardreader.h"
#include "fmbackup.h"
#include "fmmsgwnd.h"
#include "fmvip.h"
#include <QDateTime>
#include <QJsonObject>
#include <QButtonGroup>
#include <QDebug>

RechargeWnd::RechargeWnd(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::RechargeWnd),
    _cardReader(new CardReader(this)),
    _fmvip(new FMVip(this))
{
    ui->setupUi(this);
    initUi();
    initReader();
    FMBackup::instance();
    connect(_cardReader, &CardReader::hadVipNo, this, &RechargeWnd::onHadVipNo);
}

RechargeWnd::~RechargeWnd()
{
    foreach (QAbstractButton *btn, _amountBtnGroup->buttons()) {
        delete btn;
    }
    delete _amountBtnGroup;
    _cardReader->Stop();
    _cardReader->wait();
    delete _cardReader;
    delete ui;
}

void RechargeWnd::initUi()
{
    _amountBtnGroup = new QButtonGroup(this);
    connect(_amountBtnGroup, SIGNAL(buttonClicked(QAbstractButton*)), this, SLOT(onAmountBtnClicked(QAbstractButton*)));
    QStringList amountList = FMSetting::GetValue("amounts", QStringList()).toStringList();
    QGridLayout *amountLayout = (QGridLayout *)ui->amount->layout();
    int row=0, col=0;
    foreach (QString amount, amountList) {
        QPushButton* btn = new QPushButton(this);
        btn->setObjectName(amount);
        btn->setText(amount + "元");
        btn->setCheckable(true);
        btn->setCursor(QCursor(Qt::PointingHandCursor));
        _amountBtnGroup->addButton(btn);
        amountLayout->addWidget(btn, row, col);

        // 计算按钮位置
        if(++col==2) {
            row++;
            col = 0;
        }
    }
}

void RechargeWnd::clearUi()
{
    card_no = inner_no = _fm_open_id = "";
    ui->card_label->setText("未知");
    ui->max_recharge_label->setText("0.00");
    ui->amount_label->setText("0.00");
    ui->amount_edit->setText("0.00");
    ui->recharge_info_label->clear();
    foreach (QAbstractButton *btn, _amountBtnGroup->buttons()) {
        btn->setEnabled(true);
        btn->setChecked(false);
        btn->setStyleSheet("background-color: rgb(0, 204, 102);");
    }
}

void RechargeWnd::onAmountBtnClicked(QAbstractButton *button)
{
    double digit = button->objectName().toDouble();
    ui->amount_edit->setText(QString::number(digit, 'f', 2));
}

void RechargeWnd::initReader()
{
    _cardReader->start();
    connect(_cardReader, &CardReader::hadError, this, &RechargeWnd::onHadError);
}

void RechargeWnd::onHadError(const QString &error)
{
    setIsBusy(false);
    FMMsgWnd::FailureWnd(error);
}

void RechargeWnd::onHadVipNo(const QString &vipNo, const QString &uuid, bool isActived)
{
    _fm_open_id = card_no = inner_no = "";
    _needActived = !isActived;
    clearUi();
    setIsBusy(true);
    QJsonObject job;
    _fmvip->login(vipNo, uuid, job);
    setIsBusy(false);
    if(job["status_code"] != 100) {
        FMMsgWnd::FailureWnd(job["msg"].toString());
        _cardReader->ClearInfo();
    } else {
        card_no = vipNo;
        inner_no = uuid;

        ui->card_label->setText(vipNo);

        double amount = job["amount"].toInt()/100.0;
        ui->amount_label->setText(QString::number(amount, 'f', 2));

        _fm_open_id = job["fm_unique_id"].toString();
        double min_recharge = job["min_recharge_value"].toInt()/100.0;
        double max_recharge = job["max_recharge_value"].toInt()/100.0;
        QString max_recharge_str = QString::number(max_recharge, 'f', 2);

        // 按钮金额不在范围内，设置为不可用
        foreach (QAbstractButton *btn, _amountBtnGroup->buttons()) {
            double digit = btn->objectName().toDouble();
            if(digit < min_recharge || digit > max_recharge) {
                btn->setEnabled(false);
                btn->setStyleSheet("background-color: rgb(159, 159, 159);");
            } else {
                btn->setStyleSheet("background-color: rgb(0, 204, 102);");
            }
        }
        if(min_recharge == max_recharge) {
            ui->amount_edit->setText(max_recharge_str);
        }
        ui->max_recharge_label->setText(max_recharge_str);
    }
}

void RechargeWnd::on_recharge_btn_clicked()
{
    int recharge_amount = (int)ui->amount_edit->text().toDouble()*100;

    setIsBusy(true);
    QJsonObject job;
    _fmvip->recharge(_fm_open_id, recharge_amount, job);
    if(job["status_code"] == 100) {

        double after_amount = job["after_value"].toInt()/100.0;
        QString fm_id = job["fm_id"].toString();
        QDateTime dateTime = QDateTime::currentDateTime();

        // 备份
        bool isSuccess = FMBackup::instance()->insert(card_no, inner_no,
                                                 recharge_amount/100, after_amount,
                                                 fm_id, dateTime.toString("yyyy-MM-dd"),
                                                 dateTime.toString("hh:mm:ss"));

        if(!isSuccess) {
            ui->recharge_info_label->setText(FMBackup::instance()->lastError());
        }

        // 激活
        if(isSuccess && _needActived) {
            isSuccess = _cardReader->ActiveCard(ui->card_label->text());
        }
        setIsBusy(false);

        // 是否成功
        if(isSuccess) {
            _needActived = false;

            QString after_amount_str = QString::number(after_amount, 'f', 2);

            ui->amount_label->setText(after_amount_str);
            ui->recharge_info_label->setText("充值成功!");
            ui->amount_edit->setText("0.00");
            _fm_open_id = card_no = inner_no = "";
        } else {
            // 硬件激活失败，发起冲正
            _fmvip->reversal(job["fm_id"].toString());
        }

    } else {
        setIsBusy(false);
        ui->recharge_info_label->setText("充值失败:"+job["msg"].toString());
    }
}
