﻿#ifndef FM_MWRF32_H
#define FM_MWRF32_H

#include "fm_mwrf32_global.h"
#include <windows.h>
#include <QString>

#define MD5_KEY "HzdBhXmf"

/* 功能:连接读卡器设备
 * 参数:[1]端口号[2]波特率[3]扇区[4]扇区密码[5_out]设备句柄[6_out]错误原因
 * 返回:成功true
 * */
FM_MWRF32SHARED_EXPORT bool ConnectDevice(int port, int baud, int sector, const QString password, HANDLE& handle, QString& error);

/* 功能:断开读卡器设备
 * 参数:[1]设备句柄
 * 返回:成功true
 * */
FM_MWRF32SHARED_EXPORT void DisConnectDevice(const HANDLE handle);

/* 功能:激活卡片
 * 参数:[1]设备句柄[2]新的读卡密码[3]错误信息[4]默认密码[5]卡号
 * 返回:成功true
 * */
FM_MWRF32SHARED_EXPORT bool ActivateCard(const HANDLE handle, int sector, const QString newPassword, QString& vipNo, QString& uuid, QString& error);

/* 功能:读取会员号
 * 参数:[1]设备句柄[2]要读取的扇区号[3_out]会员号[4_out]UUID[5_out]错误原因
 * 返回:成功true
 * */
FM_MWRF32SHARED_EXPORT bool ReadCard(const HANDLE handle, int sector, QString& vipNo, QString& uuid, QString& error);

FM_MWRF32SHARED_EXPORT bool WriteCard(const HANDLE handle, int sector, QString data, QString &error);

FM_MWRF32SHARED_EXPORT bool LoadKeyHex(const HANDLE handle, int sector, QString password, QString &error);

#endif // FM_MWRF32_H
