﻿#include "itemdelegate.h"
#include "coupon.h"
#include <QPainter>
#include <QStyleOptionViewItem>
#include <QModelIndex>
#include <QApplication>
#include <QDebug>

ItemDelegate::ItemDelegate(QWidget *parent) :
    QStyledItemDelegate(parent)
{

}

void ItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    if(index.data().canConvert<Coupon>()) {
        Coupon coupon = qvariant_cast<Coupon>(index.data());

        QRect rect = QRect(option.rect.x(), option.rect.y(), option.rect.width(), option.rect.height());
        coupon.paint(painter, rect, option.palette);

        if (option.state & QStyle::State_Selected) {
            painter->drawImage(option.rect, QImage(":/coupon_select.png"));
        }
    } else {
        QStyledItemDelegate::paint(painter, option, index);
    }
}

QSize ItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    if(index.data().canConvert<Coupon>()) {
        Coupon coupon = qvariant_cast<Coupon>(index.data());
        return coupon.sizeHint();
    } else {
        return QStyledItemDelegate::sizeHint(option, index);
    }
}
