﻿#include "fmviplogin.h"
#include "ui_fmviplogin.h"
#include "fmvippanel.h"
#include <QFile>
#include <QMutex>
#include <QTimer>
#include "fmloading.h"
#include "fmnumpad.h"

FMVipLogin::FMVipLogin(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipLogin)
{
    numpad = NULL;
    ui->setupUi(this);
    ui->login_edit->setFocus();
    autoLoginTimer.setSingleShot(true);
    autoLoginTimer.setInterval(100);
    connect(&autoLoginTimer, &QTimer::timeout, this, &FMVipLogin::on_login_btn_clicked);
}

FMVipLogin::~FMVipLogin()
{
    qDebug() << "des FMVipLogin";
    if(numpad != NULL)
    {
        delete numpad;
        numpad = NULL;
    }
    delete ui;
}

void FMVipLogin::onstartreader()
{
    emit startreader();
}

void FMVipLogin::readVipNO(QString VipNo, QString uuid)
{
    ui->login_edit->setText(VipNo);

    QString id = VipNo;

    _session->addData(PosProps.Member_sign, id);
    _session->addData(PosProps.Inner_code, uuid);
    _session->addData(PosProps.Member_type, Member_Type::EntityCard);

    this->setEnabled(false);

    setIsBusy(true);

    emit login();
}

void FMVipLogin::onNeedActivate()
{
    activateInfoWnd = new FMMsgWnd(this);
    activateInfoWnd->show(FMMsgWnd::T_Warning, tr("fmv:此卡需要激活，请重新刷卡!"));
}

void FMVipLogin::onActivateFinished()
{
    activateInfoWnd->close();
    delete activateInfoWnd;
}

bool FMVipLogin::initWnd(Session *session)
{
    this->_session = session;
    QString version_info = getVersionInfo();
    ui->version_lable->setText(version_info);

    QString placeText;
    if(session->data(PosProps.FM_Type).toInt() == FM_Pay) {
        placeText = "输入支付码/刷实体卡";
    } else {
        placeText = "输入手机号/支付码/刷实体卡";
    }
    ui->operator_label->setText(session->data(PosProps.OperatorId).toString());
    ui->bd_label->setText(session->data(PosProps.BussinessDate).toString());
    ui->login_edit->setPlaceholderText(placeText);

    QString member_sign = session->data(PosProps.Member_sign).toString();
    if(member_sign.length() >= 16) {
        // 16位之后是内码
        session->addData(PosProps.Inner_code, member_sign.mid(16));
        session->addData(PosProps.Member_type, Member_Type::EntityCard);
        session->addData(PosProps.Member_sign, member_sign.mid(0, 16));
        ui->login_edit->setText(member_sign.mid(0, 16));
        autoLoginTimer.start();
    } else if(!member_sign.isEmpty()) {
        qDebug() << "fmv:会员账号格式错误: " << member_sign;
    }
    return true;
}

QString FMVipLogin::getVersionInfo()
{
    QByteArray versionInfo;
    QFile versionFile(qApp->applicationDirPath() + "/version.dat");
    bool isOk = versionFile.open(QIODevice::ReadOnly);
    if(isOk) {
        versionInfo = versionFile.readAll();
    } else {
        versionInfo = "未知";
    }
    versionFile.close();
    return versionInfo;
}

void FMVipLogin::on_login_btn_clicked()
{
    QString id = ui->login_edit->text();

    if(session()->data(PosProps.Member_type).toInt() != Member_Type::EntityCard) {
        switch (id.length()) {
        case 20:
            session()->addData(PosProps.Member_type, Member_Type::PayCode);
            break;
        case 18:
            session()->addData(PosProps.Member_type, Member_Type::OriginalCard);
            break;
        case 16:
            session()->addData(PosProps.Member_type, Member_Type::EntityCard);
            break;
        case 11:
            session()->addData(PosProps.Member_type, Member_Type::Phone);
            break;
        case 10:
            session()->addData(PosProps.Member_type, Member_Type::Account);
            break;
        default:
            session()->addData(PosProps.Member_type, Member_Type::Unknow);
            break;
        }

        _session->addData(PosProps.Member_sign, id);
    }

    this->setEnabled(false);

    setIsBusy(true);

    emit login();
}

void FMVipLogin::resetWnd()
{
    this->setEnabled(true);
    ui->login_edit->clear();
    ui->login_edit->setFocus();
}

void FMVipLogin::on_login_key_clicked()
{
    if(numpad == NULL)
    {
        numpad = new FMNumPad(this);
        connect(numpad, &FMNumPad::finished, this, &FMVipLogin::on_clean_numpad);
        connect(numpad, &FMNumPad::digit_click, this, &FMVipLogin::on_edit_change);
        connect(numpad, &FMNumPad::digit_delete, this, &FMVipLogin::on_delete_clicked);
        connect(numpad, &FMNumPad::digit_clear, this, &FMVipLogin::on_clear_clicked);
        connect(numpad, &FMNumPad::digit_confirm, this, &FMVipLogin::on_confirm_clicked);
        numpad->show();
        numpad->setGeometry(x() + (width()+640)/2-120, numpad->y()+20, numpad->width(), numpad->height());
    } else {
        numpad->close();
        delete numpad;
        numpad = NULL;
    }
}

void FMVipLogin::on_edit_change(QString numkey)
{
     ui->login_edit->setText(ui->login_edit->text() + numkey);
}

void FMVipLogin::on_delete_clicked()
{
    int length = ui->login_edit->text().size();
    if(length <= 1)
        ui->login_edit->setText(QString(""));
    else
        ui->login_edit->setText(ui->login_edit->text().left(length - 1));
}

void FMVipLogin::on_clear_clicked()
{
    ui->login_edit->setText(QString(""));
}
void FMVipLogin::on_confirm_clicked()
{
    on_login_btn_clicked();
}

void FMVipLogin::on_clean_numpad()
{
    if(numpad != NULL)
    {
        delete numpad;
        numpad = NULL;
    }
}
