﻿#include "tasklogin.h"
#include "fmviplogin.h"

TaskLogin::TaskLogin(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTask(jsonObj, FM_Login, session, parent)
{
}

void TaskLogin::setWindow()
{
    _window = new FMVipLogin;

    connect(qobject_cast<FMVipLogin*>(_window), FMVipLogin::login, this, TaskLogin::onLogin);

    QString member_sign = getPosJsonValue(PosProps.Member_sign).toString("");
    session()->addData(PosProps.Member_sign, member_sign);
}

void TaskLogin::packageServerReq()
{
    serverReqJsonObj[ServerProps(PosProps.Member_sign)] = _session->data(PosProps.Member_sign).toString();
    serverReqJsonObj[ServerProps(PosProps.Member_type)] = _session->data(PosProps.Member_type).toInt();
    serverReqJsonObj[ServerProps(PosProps.Inner_code)] = _session->data(PosProps.Inner_code).toString();
}

void TaskLogin::packagePOSRsp()
{
    for (QString prop : {PosProps.StatusCode, PosProps.Msg}) {
        posRspJsonObj[prop] = getServerJsonValue(prop);
    }
    posRspJsonObj[PosProps.Fm_open_id] = getServerJsonValue(PosProps.Fm_unique_id);
    posRspJsonObj[PosProps.Prompt] = 0;
}

void TaskLogin::onLogin()
{
    bool isOk = sendToServer();
    if(!isOk) {
        closeWindow();
        return;
    }

    // 认证失败
    if(getServerJsonValue(PosProps.StatusCode).toInt() != FM_API_SUCCESS) {
        setError(FM_API_SERVERERROR, serverRspJsonObj[ServerProps(PosProps.StatusCode)].toInt(), serverRspJsonObj[ServerProps(PosProps.Msg)].toString());
        FMMsgWnd::FailureWnd(serverRspJsonObj[ServerProps(PosProps.Msg)].toString());
        if(session()->data(PosProps.Member_type).toInt() == Member_Type::EntityCard) {
            closeWindow();
        }
    }
    // 认证成功但限制用支付码
    else if((session()->data(PosProps.FM_Type).toInt() == FM_Pay) &&
              (getServerJsonValue(PosProps.CanPay).toInt() != 1)) {
        FMMsgWnd::FailureWnd(ErrorNeedPayCode);
    }
    // 认证成功
    else {
        QString fm_unique_id = getServerJsonValue(PosProps.Fm_unique_id).toString();
        QString account = getServerJsonValue(PosProps.Fm_open_id).toString();
        QString birthday = getServerJsonValue(PosProps.Birthday).toString();
        QString name = getServerJsonValue(PosProps.Name).toString();

        if(session()->data(PosProps.FM_Type).toInt() == FM_Login) {
            FMMsgWnd::LoginSuccess(account,name,birthday);
            closeWindow();
        } else if(session()->data(PosProps.FM_Type).toInt() == FM_Pay && getServerJsonValue(PosProps.IsActive).toInt() == 0) {
            QString msg("该账号未激活!");
            qDebug() << msg;
            FMMsgWnd::FailureWnd(msg);
        } else {
            session()->addData(PosProps.Name, name);
            session()->addData(PosProps.Amount, getServerJsonValue(PosProps.Amount).toInt());
            session()->addData(PosProps.Birthday, birthday);
            session()->addData(PosProps.Mobile, getServerJsonValue(PosProps.Mobile).toString());
            session()->addData(PosProps.Account, account);              //服务端接口中的account字段(PosProps.Fm_open_id)
            session()->addData(PosProps.Fm_open_id, fm_unique_id);      //其实是认证接口中返回的fm_unique_id(PosProps.Fm_unique_id)
            session()->addData(PosProps.Score, getServerJsonValue(PosProps.Score).toInt());
            session()->addData(PosProps.Score_value, getServerJsonValue(PosProps.Score_value).toInt());
            session()->addData(PosProps.IsActive, getServerJsonValue(PosProps.IsActive).toInt());
            session()->addData(PosProps.Max_recharge_value, getServerJsonValue(PosProps.Max_recharge_value).toInt());
            session()->addData(PosProps.Min_recharge_value, getServerJsonValue(PosProps.Min_recharge_value).toInt());
            closeWindow();
        }
    }

    if(_window!=nullptr) {
        _window->resetWnd();
    }
}
