#include "taskfactory.h"
#include "tasklogin.h"
#include "taskpay.h"
#include "taskmanage.h"
#include "taskfinal.h"
#include "taskothers.h"
#include "global.h"
#include "fmmsgwnd.h"
#include <QJsonDocument>
#include <QJsonObject>
#include <QJsonParseError>
#include <QDebug>

TaskFactory::TaskFactory(QObject *parent) : QObject(parent)
{

}

FMTask* TaskFactory::Task(QByteArray data)
{
    QJsonParseError error;
    QJsonDocument doc = QJsonDocument::fromJson(data, &error);

    FMTask* task = nullptr;

    if(error.error != QJsonParseError::NoError) {
        FMMsgWnd::FailureWnd("fmv:请求数据解析失败.\n" + error.errorString());
        return task;
    }
    QJsonObject jsonObj = doc.object();

    FM_TYPE type = (FM_TYPE)FM_Type_List.indexOf(jsonObj["fm_cmd"].toString());
    switch (type) {
    case FM_Manage: {
        task = new TaskManage(jsonObj);
        break;
    }
    case FM_Login: {
        task = new TaskLogin(jsonObj);
        break;
    }
    case FM_Pay: {
        task = new TaskPay(jsonObj);
        break;
    }
    case FM_Final: {
        task = new TaskFinal(jsonObj);
        break;
    }
    case FM_Order_Refund: {
        task = new TaskRefundOrder(jsonObj);
        break;
    }
    default:
        break;
    }

    return task;
}
