﻿#include <QMenu>
#include <QAction>
#include <QTimer>
#include <winsock2.h>
#include "fmvipdispatcher.h"
#include "fmtask.h"
#include "taskfactory.h"

FMVipDispatcher::FMVipDispatcher(QObject *parent) :
    QObject(parent),
    FMApiRelay(),
    _posSocketTimer(new QTimer(this)),
    fmTask(nullptr)
{
    connect(this, SIGNAL(doTask()), this, SLOT(onDoTask()));

    _posSocketTimer->setInterval(5000);
    connect(_posSocketTimer, SIGNAL(timeout()), SLOT(onCheckSocket()));
    connect(this, SIGNAL(startSocketTimer()), _posSocketTimer, SLOT(start()));
    connect(this, SIGNAL(stopSocketTimer()), _posSocketTimer, SLOT(stop()));
}

FMVipDispatcher::~FMVipDispatcher()
{
    del_p(_posSocketTimer);
}

BOOL FMVipDispatcher::Transfer(LPSTR data, LPSTR &rsp, UINT &rsp_len)
{
    if (strcmp(data, QuitCMD) != 0) {
        emit startSocketTimer();
        mutex.lock();
        reqData = QString::fromLocal8Bit(data).toUtf8();
        emit doTask();
        condition.wait(&mutex);
        mutex.unlock();

        QString strData(rspData);
        QByteArray bData = strData.toLocal8Bit();
        rsp = bData.data();
        rsp_len = bData.length();

        emit stopSocketTimer();
    }
    return true;
}

void FMVipDispatcher::onDoTask()
{
    qDebug() << "===============";
    qDebug() << "Recv POS reqData: " << QString::fromUtf8(reqData);

    fmTask = TaskFactory::Task(reqData);

    if (fmTask == nullptr) {
        rspData = "{\"msg:\":\"未知的请求类型\"}";
    } else {
        rspData = fmTask->doTask();
    }
    qDebug() << "Send to pos: " << QString::fromUtf8(rspData);
    qDebug() << "===============";

    condition.wakeAll();

    del_p(fmTask);
}

void FMVipDispatcher::onCheckSocket()
{
    if(_socket <=0 ) {
        emit stopSocketTimer();
        return;
    }

    WORD wVersionRequested;
    WSADATA wsaData;

    wVersionRequested = MAKEWORD(2, 2);
    WSAStartup(wVersionRequested, &wsaData);

    HANDLE closeEvent = WSACreateEvent();
    WSAEventSelect(_socket, closeEvent, FD_CLOSE);

    DWORD dwRet = WaitForSingleObject(closeEvent, 0);

    if(dwRet == WSA_WAIT_EVENT_0) {
        onDisconnected();
    }

    WSACloseEvent(closeEvent);

    WSACleanup();
}

void FMVipDispatcher::onDisconnected()
{
    fmTask->stopTask();
    FMMsgWnd::FailureWnd("操作时间过长，POS已断开Socket连接，请重新操作！");
    condition.wakeAll();
}

void FMVipDispatcher::createSysIcon()
{
    QIcon icon = QIcon(":/img_logo.png");
    _sysIcon.setIcon(icon);
    _sysIcon.setToolTip("FMVIP");
    auto menu = new QMenu();
    auto action = new QAction("退出", this);
    connect(action, SIGNAL(triggered(bool)), this, SLOT(onQuit()));
    menu->addAction(action);
    _sysIcon.setContextMenu(menu);

    _sysIcon.show();

    _sysIcon.showMessage("非码VIP提醒", "非码VIP程序已启动");
}

void FMVipDispatcher::onQuit()
{
    if(fmTask != nullptr) {
        fmTask->stopTask();
    }
    qDebug() << __FUNCTION__;
    LPSTR data = QuitCMD;
    unsigned int a;
    Transfer(data, data, a);
    qApp->quit();
}
