﻿#ifndef RECHARGEWND_H
#define RECHARGEWND_H

#include "fmvipwnd.h"

class QButtonGroup;
class QAbstractButton;
class CardReader;
class FMVip;

namespace Ui {
class RechargeWnd;
}

class RechargeWnd : public FMVipWnd
{
    Q_OBJECT

public:
    explicit RechargeWnd(QDialog *parent = 0);
    ~RechargeWnd();

private:
    Ui::RechargeWnd *ui;

    QButtonGroup *_amountBtnGroup;

    void initUi();
    void clearUi();
    void initReader();

    CardReader *_cardReader;
    FMVip *_fmvip;
    bool _needActived;
    QString card_no, inner_no, _fm_open_id;

private slots:
    void onAmountBtnClicked(QAbstractButton* button);
    void onHadError(const QString &error);
    void onHadVipNo(const QString &vipNo, const QString &uuid, bool isActived);
    void on_recharge_btn_clicked();
};

#endif // RECHARGEWND_H
