﻿#ifndef FMVIPWND_H
#define FMVIPWND_H

#include <QDialog>
#include <QJsonObject>
#include <QMap>
#include <QDebug>
#include "fmloading.h"
#include "session.h"

class FMVipWnd : public QDialog
{
    Q_OBJECT
public:
    explicit FMVipWnd(QDialog *parent = 0);
    ~FMVipWnd();

    void    setIsBusy(const bool isBusy = true);
    virtual void    resetWnd(){this->setEnabled(true);}

    int     exec();
    bool    close();

    virtual bool        initWnd(Session* session) {this->_session = session; return true;}
    Session*    session() const {return _session;}

public slots:
    void    on_close_btn_clicked();
private:
    FMLoading*  loadingWindow;
protected:
    bool            _isBusy;
    Session         *_session;

    void            keyPressEvent(QKeyEvent *e);
#ifdef Q_OS_WIN
protected:
    bool    nativeEvent(const QByteArray &eventType, void *message, long *result);
    void    paintEvent(QPaintEvent *event);
protected:
    long    winNCHitTest(MSG *msg);

#endif
};

#endif // FMVIPWND_H
