﻿#ifndef FMVIPLOGIN_H
#define FMVIPLOGIN_H

#include <QTimer>
#include "fmvipwnd.h"
#include "fmmsgwnd.h"

class QNetworkReply;

class FMNumPad;

namespace Ui {
class FMVipLogin;
}

class FMVipLogin : public FMVipWnd
{
    Q_OBJECT

public:
    explicit FMVipLogin(QDialog *parent = 0);
    ~FMVipLogin();

    QString getVersionInfo();

    bool initWnd(Session *session);
protected:
    void    resetWnd();
signals:
    void    login();
    void    startreader();
public slots:
    void    on_login_btn_clicked();
    void    on_edit_change(QString numkey);
    void    readVipNO(QString VipNO, QString uuid);
    void    onstartreader();
    void    onNeedActivate();
    void    onActivateFinished();

    void    on_delete_clicked();
    void    on_clear_clicked();
    void    on_confirm_clicked();
private slots:
    void on_login_key_clicked();
    void on_clean_numpad();
private:
    Ui::FMVipLogin *ui;
    FMNumPad *numpad;
    FMMsgWnd *activateInfoWnd;
    QTimer autoLoginTimer;
};

#endif // FMVIPLOGIN_H
