﻿#include "fmvipfund.h"
//#include "fmvipforward.h"
#include "ui_fmvipfund.h"
#include "fmnumpad.h"
#include "fmmsgwnd.h"
#include "fmconfirmwnd.h"

FMVipFund::FMVipFund(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipFund),
    _digit_group(new QButtonGroup(this))
{
    numpad = NULL;
    ui->setupUi(this);
    _digit_group->addButton(ui->one);
    _digit_group->addButton(ui->two);
    _digit_group->addButton(ui->five);
    _digit_group->addButton(ui->ten);

    connect(_digit_group, SIGNAL(buttonClicked(QAbstractButton*)), SLOT(onDigitChecked(QAbstractButton*)));
}

FMVipFund::~FMVipFund()
{
    if(numpad != NULL)
    {
        delete numpad;
        numpad = NULL;
    }
    delete ui;
}

bool FMVipFund::initWnd(Session *session)
{
    _session = session;

    QString operator_id = session->data(PosProps.OperatorId).toString();
    QString business_date = session->data(PosProps.BussinessDate).toString();
    QString fm_id = session->data(PosProps.Account).toString();
    QString name = session->data(PosProps.Name).toString();
    QString birthday = session->data(PosProps.Birthday).toString();

    double amount = session->data(PosProps.Amount).toInt() / 100.0;

    double max_recharge = session->data(PosProps.Max_recharge_value).toInt() / 100.0;
    double min_recharge = session->data(PosProps.Min_recharge_value).toInt() / 100.0;
    if(max_recharge == min_recharge && min_recharge != 0) {
        FMMsgWnd::FailureWnd("此卡不可充值!");
        return false;
    }
    for (auto &btn : _digit_group->buttons()) {
        QString digit = btn->text();
        digit = digit.replace("￥", "");
        double digit_amount = digit.toDouble();
        if(digit_amount < min_recharge || digit_amount > max_recharge) {
            btn->setEnabled(false);
        }
    }

    QString show_amount_str = QString::number(amount, 'f', 2);

    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);
    ui->id_label->setText(fm_id);
    ui->balance_label->setText(show_amount_str);
    ui->name_label->setText(name);
    ui->bir_label->setText(birthday);
    ui->point_label->setText(QString::number(session->data(PosProps.Score).toInt()));

    ui->fund_btn->setFocus();
    return true;
}

void FMVipFund::on_fund_btn_clicked()
{
    qDebug() << __FUNCTION__;
    int fundAmount = ui->amount_edit->text().toDouble() * 100;

    QString text = QString("确认充值 %1 元？").arg(ui->amount_edit->text().toDouble());
    if(FMConfirmWnd::Confirm(text) != FMConfirmWnd::FMOk){
        return;
    }

    _session->addData(PosProps.ChargeAmount, fundAmount);

    setIsBusy(true);

    emit fund();
}

void FMVipFund::onDigitChecked(QAbstractButton *btn)
{
    QString digit = btn->text();
    digit = digit.replace("￥", "");
    ui->amount_edit->setText(digit);
}

//void FMVipFund::on_fund_key_clicked()
//{
//    if(numpad == NULL)
//    {
//        numpad = new FMNumPad();
//        connect(numpad, &FMNumPad::finished, this, &FMVipFund::on_clean_numpad);
//        connect(numpad, &FMNumPad::digit_click, this, &FMVipFund::on_edit_change);
//        connect(numpad, &FMNumPad::digit_delete, this, &FMVipFund::on_delete_clicked);
//        connect(numpad, &FMNumPad::digit_clear, this, &FMVipFund::on_clear_clicked);
//        connect(numpad, &FMNumPad::digit_confirm, this, &FMVipFund::on_confirm_clicked);
//    }
//    numpad->show();
//    numpad->setGeometry(x() + width(), numpad->y(), numpad->width(), numpad->height());
//}

void FMVipFund::on_edit_change(QString numkey)
{
     ui->amount_edit->setText(ui->amount_edit->text() + numkey);
}

void FMVipFund::on_delete_clicked()
{
    int length = ui->amount_edit->text().size();
    if(length <= 1)
        ui->amount_edit->setText(QString(""));
    else
        ui->amount_edit->setText(ui->amount_edit->text().left(length - 1));
}

void FMVipFund::on_clear_clicked()
{
    ui->amount_edit->setText(QString(""));
}
void FMVipFund::on_confirm_clicked()
{
    on_fund_btn_clicked();
}

void FMVipFund::on_clean_numpad()
{
    if(numpad != NULL)
    {
        delete numpad;
        numpad = NULL;
    }
}
