﻿#include "errcodedialog.h"
#include "ui_errcodedialog.h"

ErrCodeDialog::ErrCodeDialog(QWidget * parent, Qt::WindowFlags f) :
    QDialog(parent, f),
    ui(new Ui::ErrCodeDialog)
{
    ui->setupUi(this);
    setWindowTitle(QString::fromLocal8Bit("非码卡券"));
    setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint);
    setAutoFillBackground(false);  //这个不设置的话就背景变黑  
    setAttribute(Qt::WA_TranslucentBackground,true); 
    setAttribute(Qt::WA_QuitOnClose, false);
    connect( ui->btnCannel, &QPushButton::clicked, this, &ErrCodeDialog::accept);
}

ErrCodeDialog::~ErrCodeDialog()
{
    delete ui;
}

void ErrCodeDialog::showForInvalid(const QString& coupon, QWidget *parent)
{
    ErrCodeDialog v(parent);
//    v.setGeometry( 0,0,350,470);
    v.ui->topInvalidWidget->setObjectName("topInvalidWidget");
    v.ui->topInvalidWidget->setStyleSheet( v.ui->topInvalidWidget->styleSheet());

    v.ui->labTime->setVisible( false);
    v.ui->labActName->setVisible( false);
    v.ui->labCodeName->setVisible( false);
    v.ui->labFolat->setVisible( false);

    v.ui->labCode->setText(coupon );

    v.exec();
}

void ErrCodeDialog::showForExpird(const QString& act_name, const QString& code_name, const QString& time_name, const QString& coupon, QWidget *parent)
{
    ErrCodeDialog v(parent);
//    v.setGeometry( 0,0,350,470);
    v.ui->topInvalidWidget->setObjectName("topExpirdWidget");
    v.ui->topInvalidWidget->setStyleSheet( v.ui->topInvalidWidget->styleSheet());

    v.ui->labTime->setVisible( true);
    v.ui->labActName->setVisible( true);
    v.ui->labCodeName->setVisible( true);

    v.ui->labCode->setText(coupon );
    v.ui->labTime->setText( time_name);
    v.ui->labActName->setText( act_name);
    v.ui->labCodeName->setText( code_name);

    v.exec();
}

void ErrCodeDialog::showForErr(const QString& coupon, const QString& mess, QWidget *parent)
{
    ErrCodeDialog v(parent);
//    v.setGeometry( 0,0,350,470);
    v.ui->topInvalidWidget->setObjectName("topExpirdWidget");
    v.ui->topInvalidWidget->setStyleSheet( v.ui->topInvalidWidget->styleSheet());

    v.ui->labTime->setVisible( false);

    v.ui->labCodeName->setVisible( false);
    v.ui->labFolat->setVisible( false);

    v.ui->labActName->setVisible( true);
    v.ui->labCode->setText(coupon );
    v.ui->labActName->setText( mess);

    v.exec();
}

void ErrCodeDialog::showForMismatch(const QString &coupon, const QString &mess, QWidget *parent)
{
    ErrCodeDialog v(parent);
//    v.setGeometry( 0,0,350,470);
    v.ui->topInvalidWidget->setObjectName("topExpirdWidget");
    v.ui->topInvalidWidget->setStyleSheet( v.ui->topInvalidWidget->styleSheet());

    v.ui->labTime->setVisible( false);

    v.ui->labCodeName->setVisible( false);
    v.ui->labFolat->setVisible( false);

    v.ui->labActName->setVisible( true);
    v.ui->labCode->setText(coupon );
    v.ui->labActName->setText( mess);

    v.exec();
}
