﻿#include "taskpay.h"
#include "fmviporder.h"
#include "tasklogin.h"
#include "taskothers.h"

TaskPay::TaskPay(QJsonObject &jsonObj, QObject *parent)
    :FMTask(jsonObj, FM_Pay, 0, parent)
{
    posReqJsonObj[PosProps.TransId] = createTransId();
}

TaskPay::~TaskPay()
{
}

QByteArray TaskPay::doTask()
{
    preTask = new TaskLogin(posReqJsonObj, _session, this);
    preTask->session()->addData(PosProps.FM_Type, FM_Pay);
    QByteArray loginRst = preTask->doTask();
    if(preTask->error() != FM_API_SUCCESS) {
        return loginRst;
    }
    this->_session = preTask->session();

    couponThread = new TaskCouponThread(posReqJsonObj, _session, this);
    couponThread->start();
    connect(couponThread, SIGNAL(finished(Session*)), SLOT(onGetCoupons(Session*)));
    return FMTask::doTask();
}

void TaskPay::onGetCoupons(Session* session)
{
    couponThread->exit();

    _session->addData(PosProps.CouponMap, session->getCouponMap(PosProps.CouponMap));
    if(_window != nullptr) {
        qobject_cast<FMVipOrder*>(_window)->initCouponItems();
        _window->setIsBusy(false);
        _window->setEnabled(true);
    }
}

void TaskPay::setWindow()
{
    _window = new FMVipOrder;
    _window->setIsBusy();
    _window->setEnabled(false);

    for (QString prop : {PosProps.OrderAmount, PosProps.PaidAmount, PosProps.UndisAmount, PosProps.StandardAmount}) {
        session()->addData(prop, getPosJsonValue(prop).toInt());
    }

    connect(qobject_cast<FMVipOrder*>(_window), SIGNAL(pay()), this, SLOT(onPay()));
}

void TaskPay::packageServerReq()
{
    QJsonObject transObj;
    transObj[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();

    int codeAmount = session()->data(PosProps.CodeAmount).toInt();
    QJsonArray payList;
    QJsonObject paymentCodeObj;
    paymentCodeObj[ServerProps(PosProps.Pay_id)] = "20001";
    paymentCodeObj[ServerProps(PosProps.Amount)] = codeAmount;
    payList.append(paymentCodeObj);

    //! NOTE 老乡鸡暂时没有积分支付 2017-09-25 15:45
    int scoreAmount = session()->data(PosProps.ScoreAmount).toInt();
    if(scoreAmount > 0) {
        QJsonObject paymentScoreObj;
        paymentScoreObj[ServerProps(PosProps.Pay_id)] = "20002";
        paymentScoreObj[ServerProps(PosProps.Amount)] = scoreAmount;
        payList.append(paymentScoreObj);
    }

    //代金券/商品券支付详情
    QMap<QString, QVariant> coupons = session()->data(PosProps.CouponMap).toMap();
    // 将代金券按金额从大到小排序
    QList<Coupon> couponList;
    for(QMap<QString, QVariant>::const_iterator it = coupons.constBegin(); it != coupons.constEnd(); it++)
    {
        couponList.append(it.value().value<Coupon>());
    }
    qSort(couponList.begin(), couponList.end(), [=](const Coupon &first, const Coupon &second){
        return (first.disAmount() > second.disAmount());
    });
    // 计算使用的代金券金额

    int needAmount = session()->data(PosProps.NeedAmount).toInt();
    int needCouponAmount = needAmount - codeAmount - scoreAmount;
    int couponAmount = 0;
    foreach(Coupon c, couponList)
    {
        if(needCouponAmount <= 0) {
            break;
        }
        QJsonObject coupon;
        double couponDisAmount = c.disAmount() * 100;
        if(couponDisAmount <= needCouponAmount) {
            couponDisAmount = couponDisAmount;
            needCouponAmount -= couponDisAmount;
        } else {
            couponDisAmount = MAX(0, needCouponAmount);
            needCouponAmount = 0;
        }
        couponAmount += couponDisAmount;
        coupon[ServerProps(PosProps.Amount)] = couponDisAmount;
        coupon[ServerProps(PosProps.Pay_id)] = "20003";
        coupon[ServerProps(PosProps.Coupon_code)] = c.code();
        payList.push_back(coupon);
    }

    transObj[ServerProps(PosProps.Pay_ids)] = payList;
    serverReqJsonObj[ServerProps(PosProps.Transaction)] = transObj;
    serverReqJsonObj[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);
}

void TaskPay::packagePOSRsp()
{
    for (QString prop : {PosProps.StatusCode, PosProps.Msg, PosProps.Fm_id}) {
        posRspJsonObj[prop] = getServerJsonValue(prop);
    }
    posRspJsonObj[PosProps.Prompt] = 1;
    posRspJsonObj[PosProps.Fm_open_id] = session()->data(PosProps.Fm_open_id).toString();

    int paidTotalAmount = 0;

    QJsonArray pay_ids;
    QJsonObject pay_id;
    pay_id[PosProps.Pay_id] = "20001";
    pay_id[PosProps.Pay_str] = "会员储值金支付";
    int codeAmount = getServerJsonValue(PosProps.CodeAmount).toInt();
    pay_id[PosProps.Paid_total_amount] = codeAmount;
    paidTotalAmount += codeAmount;
    pay_ids.append(pay_id);

    pay_id[PosProps.Pay_id] = "20002";
    pay_id[PosProps.Pay_str] = "会员积分支付";
    int scoreAmount = getServerJsonValue(PosProps.ScoreAmount).toInt();
    pay_id[PosProps.Paid_total_amount] = scoreAmount;
    paidTotalAmount += scoreAmount;
    pay_ids.append(pay_id);

    for(auto coupon : getServerJsonValue(PosProps.Coupons).toArray()) {
        QJsonObject cp = coupon.toObject();
        pay_id[PosProps.Pay_id] = "20003";
        pay_id[PosProps.Pay_str] = "代金券支付";
        int couponAmount = cp[ServerProps(PosProps.Coupon_disAmount)].toInt();
        pay_id[PosProps.Paid_total_amount] = couponAmount;
        paidTotalAmount += couponAmount;
        pay_id[PosProps.Coupon_code] = cp[ServerProps(PosProps.Coupon_code)];
        pay_ids.append(pay_id);
    }
    posRspJsonObj[PosProps.Pay_ids] = pay_ids;
    posRspJsonObj["total_amount"] = session()->data(PosProps.OrderAmount).toInt();
    posRspJsonObj[PosProps.Paid_total_amount] = paidTotalAmount;
    posRspJsonObj["invoice_amount"] = paidTotalAmount;
    posRspJsonObj["incentives_amount"] = 0;
    posRspJsonObj["forward"] = posReqJsonObj["forward"];
}

void TaskPay::onPay()
{
    sendToServer();
    // 如果超时错误，则发起冲正
    if(error() == FM_API_TIMEOUT) {
        FMTask *reversalTask = new TaskReversal(posReqJsonObj, this);
        reversalTask->doTask();
    }
    closeWindow();
}

//TaskPay::TaskCouponThread::TaskCouponThread(QJsonObject &jsonObj, Session *session, QObject *parent):
//    _session(session),
//    QThread(parent)
//{
//    task = new TaskCoupon(jsonObj, session, parent);
//}

//void TaskPay::TaskCouponThread::run()
//{
//    task->doTask();
//    _session = task->session();
//}
