﻿#include "fmsetting.h"
#include <QSettings>
#include <QApplication>
#include <QPrinterInfo>
#include <QDebug>

FMSetting::FMSetting()
{
    _sets = new QSettings(qApp->applicationDirPath()+"/FMVip.cfg", QSettings::IniFormat);
    _sets->setIniCodec("GBK");
}

FMSetting *FMSetting::Instance()
{
    static FMSetting instance;
    return &instance;
}

QVariant FMSetting::getValue(const QString &k, QVariant default_val)
{
    return _sets->value(k, default_val);
}

bool FMSetting::setValue(const QString &k, QVariant v)
{
    _sets->setValue(k, v);
    return (_sets->value(k) == v);
}

QVariant FMSetting::GetValue(const QString &k, QVariant default_val)
{
    return FMSetting::Instance()->getValue(k, default_val);
}

bool FMSetting::SetValue(const QString &k, QVariant v)
{
    return FMSetting::Instance()->setValue(k, v);
}

QStringList FMSetting::GetPrinterList()
{
    QStringList printerList = QPrinterInfo::availablePrinterNames();
    qDebug() << "打印机列表：" << printerList;
    if(FMSetting::GetValue("Printer/name", "") == "") {
        FMSetting::SetValue("Printer/name", printerList.first());
    }
    return printerList;
}
