#include "resend.h"
#include "fmbackup.h"
#include "fmnetwork.h"
#include <QSqlQuery>
#include <QSqlRecord>
#include <QNetworkReply>
#include <QDebug>

ReSend::ReSend()
{
}

ReSend::~ReSend()
{
}

void ReSend::trySend()
{
    QSqlRecord record;
    QSqlQuery reqDataQuery = FMBackup::instance()->reqDataQuery();
    while(reqDataQuery.next())
    {
        record = reqDataQuery.record();
        int id = record.value(ID).toInt();
        QString url = record.value(URL).toString();
        QByteArray data = record.value(DATA).toByteArray();

        FMNetwork net;
        data = net.send(&url, &data);

        // 如果发送失败则不再继续发送
        if(net.error() != FM_API_SUCCESS) {
            break;
        } else{
            FMBackup::instance()->removeReqData(id);
            qDebug() << "重发响应成功："<< QString::fromUtf8(data);
        }
    }
}

void ReSend::run()
{
    int waitTime = 0;
    while(true)
    {
        if(++waitTime > 30) {
            trySend();
            waitTime = 0;
        }
        QThread::sleep(1);
    }
}
