﻿#ifndef CARDREADER_H
#define CARDREADER_H

#include "fmlogger.h"
#include <QThread>
#include <windows.h>
#include <QMutex>
#include <QWaitCondition>

class CardReader : public QThread
{
    Q_OBJECT

public:
    explicit CardReader(QObject *parent = 0);
    ~CardReader();

    void Stop();

    QString LastError() const;

    bool ConnectDevice(int port, int baud);
    void DisConnectDevice();

    bool ActiveCard(QString vipNo);

    void ClearInfo();
signals:
    void hadError(const QString &error);

    void hadVipNo(const QString &vipNo, const QString &uuid, bool isActived);

protected:
    void run();

private:
    HANDLE _handle;
    QString _error;
    bool _isRunning;

    qint8 def_sector, sector;
    QString def_pwd, password;

    QString willActiveCard, needActiveCard, lastUUID;

    QMutex              mutex;
    QWaitCondition      waitActive;
    bool activedSuccess;


    void setError(const QString& error);
    bool OperatorCard();
    bool LoadKeyHex(qint8 sec, const QString &password);

    /**
     * @brief ReadData
     * @param sec       扇区号0-15
     * @param data      数据
     * @param blockNums 块数量
     * @param isHex     是否是16进制
     * @return
     */
    bool ReadData(qint8 sec, QString &data, qint8 blockNums=1, bool isHex=true);

    bool Active(const QString &vipNo);
};

#endif // CARDREADER_H
