﻿#include "consumptiondialog.h"
#include "ui_consumptiondialog.h"


ConsumptionDialog::ConsumptionDialog(QWidget * parent, Qt::WindowFlags f) :
    QDialog(parent, f),
    ui(new Ui::ConsumptionDialog)
{
    ui->setupUi(this);
    setWindowTitle(QString::fromLocal8Bit("非码卡券"));
    setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint);
    setAutoFillBackground(false);  //这个不设置的话就背景变黑  
    setAttribute(Qt::WA_TranslucentBackground,true); 
    setAttribute(Qt::WA_QuitOnClose, false);
    connect( ui->btnConsumption, &QPushButton::clicked, this, &ConsumptionDialog::accept);
    connect( ui->btnCannel, &QPushButton::clicked, this, &ConsumptionDialog::reject);
}

ConsumptionDialog::~ConsumptionDialog()
{
    delete ui;
}

bool ConsumptionDialog::ShowForUnConsum(const QString& act_name, const QString& code_name, const QString& time_name, const QString& coupon, QWidget *parent)
{
    ConsumptionDialog v(parent);
//    v.setGeometry( 0,0,350,470);
    v.ui->topNoConsumeWidget->setObjectName( "topNoConsumeWidget");
    v.ui->topNoConsumeWidget->setStyleSheet( v.ui->topNoConsumeWidget->styleSheet());

    v.ui->btnConsumption->setObjectName( "btnConsumption");
    v.ui->btnConsumption->setStyleSheet(  v.ui->btnConsumption->styleSheet());
    v.ui->btnConsumption->setEnabled( true);

    v.setData( act_name,code_name ,time_name,coupon );

    if( v.exec() == QDialog::Accepted){
        return true;
    }

    return false;
}

bool ConsumptionDialog::ShowForHasConsum(const QString& act_name, const QString& code_name, const QString& time_name, const QString& coupon, QWidget *parent)
{
    ConsumptionDialog v(parent);
//    v.setGeometry( 0,0,350,470);

    v.ui->topNoConsumeWidget->setObjectName( "topHasConsumeWidget");
    v.ui->topNoConsumeWidget->setStyleSheet( v.ui->topNoConsumeWidget->styleSheet());

    v.ui->btnConsumption->setObjectName( "btnConsumNull");
    v.ui->btnConsumption->setStyleSheet( v.ui->btnConsumption->styleSheet());
    v.ui->btnConsumption->setEnabled( false);
    v.setData( act_name,code_name ,time_name,coupon );

    if( v.exec() == QDialog::Accepted){
        return true;
    }

    return false;
}

void ConsumptionDialog::setData(const QString& act_name, const QString& code_name, const QString& time_name, const QString& coupon)
{
    ui->labCode->setText( coupon);
    ui->labCodeName->setText( code_name);
    ui->labActName->setText( act_name);
    ui->labTime->setText( time_name);
}