﻿#include "taskothers.h"
#include "coupon.h"

/// 优惠券查询
TaskCoupon::TaskCoupon(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Coupon, session, parent)
{

}

void TaskCoupon::packageServerReq()
{
    serverReqJsonObj[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);

    QJsonObject transaction;
    transaction[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();
    transaction[ServerProps(PosProps.PaidAmount)] = getPosJsonValue(PosProps.OrderAmount);
    // 产品列表
    QJsonArray propducts;
    for(auto pValue : getPosJsonValue(PosProps.Products).toArray())
    {
        auto po = pValue.toObject();
        QJsonObject spo;
        for(auto prop : {PosProps.ConsumeNum, PosProps.ProductId}) {

            spo[ServerProps(prop)] = po[prop];
        }
        double price = po[PosProps.Price].toDouble() / po[PosProps.ConsumeNum].toDouble();
        spo[ServerProps(PosProps.Price)] = price;
        propducts.append(spo);
    }
    transaction[ServerProps(PosProps.Products)] = propducts;

    serverReqJsonObj[ServerProps(PosProps.Transaction)] = transaction;
}

void TaskCoupon::packagePOSRsp()
{
    for(auto prop : {PosProps.Fm_open_id, PosProps.StatusCode, PosProps.Msg}) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }

    QMap<QString, QVariant> couponMap;
    for (auto value : getServerJsonValue(PosProps.CouponList).toArray())
    {
        QJsonObject couponOb = value.toObject();
        QString code = couponOb[ServerProps(PosProps.Coupon_code)].toString();
        double amount = couponOb[ServerProps(PosProps.Coupon_disAmount)].toInt() / 100.0;
        QString desc = couponOb[ServerProps(PosProps.Coupon_name)].toString();

        double limitAmount = couponOb[ServerProps(PosProps.Coupon_limitAmount)].toInt() / 100.0;
        bool isCompatible = (couponOb[ServerProps(PosProps.Coupon_compatible)].toInt() == 1);

        Coupon c(desc, code, amount, limitAmount, isCompatible);
        QVariant v;
        v.setValue(c);
        couponMap[code] = v;
    }

#ifdef FMTEST
    for(double i=1.99; i<=2.01; i=i+0.01) {
        QString code = QString::number(i);
        Coupon c(QString::fromUtf8("测试券%1").arg(i), code, i, 0, true);
        QVariant v;
        v.setValue(c);
        couponMap[code] = v;
    }
#endif

    session()->addData(PosProps.CouponMap, couponMap);
}

/// 退单
TaskRefundOrder::TaskRefundOrder(QJsonObject &jsonObj, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Order_Refund, 0, parent)
{

}

void TaskRefundOrder::packageServerReq()
{
    QString transId = getPosJsonValue(PosProps.TransId).toString("");
    QString fmId = getPosJsonValue(PosProps.Fm_id).toString("");
    serverReqJsonObj[ServerProps(PosProps.TransId)] = transId;
    serverReqJsonObj[ServerProps(PosProps.Fm_id)] = fmId;
}

void TaskRefundOrder::packagePOSRsp()
{
    for(auto prop : {PosProps.StatusCode, PosProps.Msg}) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }
    posRspJsonObj[PosProps.Prompt] = 1;
}

/// 冲正
TaskReversal::TaskReversal(QJsonObject &jsonObj, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Reversal, 0, parent)
{
    posReqJsonObj = jsonObj;
}

void TaskReversal::packageServerReq()
{
    serverReqJsonObj[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);
}

void TaskReversal::packagePOSRsp()
{
}
