﻿#include "fmp_redeem.h"
#include "scanningdialog.h"
#include "consumptiondialog.h"
#include "consumokdialog.h"
#include "errcodedialog.h"
#include "global.h"
#include "fmsetting.h"
#include <QJsonDocument>
#include <QJsonObject>
#include <QJsonParseError>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QEventLoop>
#include <QTimer>
#include <QJsonArray>
#include <QApplication>
#include <QResource>
#include <QSettings>
#include <QMessageBox>

FMPRedeem::FMPRedeem(QJsonObject &jsonObj, QObject *parent)
    :FMTask(jsonObj, FM_NotVipCoupon, 0, parent)
{
    _clientReqCount = 0;
    _url = FMSetting::Instance()->GetValue(COUPON_SERVER, "").toString();
}

FMPRedeem::~FMPRedeem()
{
}

QByteArray FMPRedeem::doTask()
{
    QJsonObject result = Redeem(posReqJsonObj);
    return QJsonDocument(result).toJson(QJsonDocument::Compact);
}

QJsonValue FMPRedeem::SearchJsonObject(QJsonObject& searchJson, QString searchKey)
{
    QJsonValue value;
    if(searchJson.contains(searchKey))
    {
        return searchJson[searchKey];
    }
    else
    {
        foreach(QString key, searchJson.keys())
        {
            if(searchJson[key].isObject())
            {
                QJsonObject ob = searchJson[key].toObject();
                value = SearchJsonObject(ob, searchKey);
            }
            else if(searchJson[key].isArray())
            {
                QJsonArray arr = searchJson[key].toArray();
                value = SearchJsonArray(arr, searchKey);
            }
        }
    }
    return value;
}

QJsonValue FMPRedeem::SearchJsonArray(QJsonArray& searchJson, QString searchKey)
{
    QJsonValue value;
    for(int i = 0; i < searchJson.size(); i++)
    {
        if(searchJson[i].isObject())
        {
            QJsonObject ob = searchJson[i].toObject();
            value = SearchJsonObject(ob, searchKey);
        }
        else if(searchJson[i].isArray())
        {
            QJsonArray arr = searchJson[i].toArray();
            value = SearchJsonArray(arr, searchKey);
        }
    }
    return value;
}

QJsonObject FMPRedeem::Reverse(QJsonObject request)
{
    request["reqtype"] = 3;
    QByteArray reqData = QJsonDocument(request).toJson(QJsonDocument::Compact);
    reqData = CheckSendArray(reqData);
    QJsonObject retJson = SendRequest(reqData);
    return retJson;
}

QJsonObject FMPRedeem::Redeem(const QJsonObject &request)
{    
    _products_info = request["products"].toArray();

    _store_id = request["store_id"].toString();
    _station_id = request["pos_id"].toString();
    _operator_id = request["operator_id"].toString();
    _partner_id = PAY_PARTNER_ID;
    
    //显示扫码界面获取券码
    ScanningDialog scanningDialog;
    if(scanningDialog.exec() != QDialog::Accepted)
    {
        QJsonObject ret;
        ret["statusCode"] = FM_API_WINDOWCLOSE;
        ret["msg"] = "窗口关闭";
        return ret;
    }
    _coupon = scanningDialog.code;
    
    QJsonObject json;
    json.insert("ver", 2);
    json.insert("clientReqCount", ++_clientReqCount%=10000000);
    json.insert("reqtype", 0);
    json.insert("partnerId", _partner_id);
    json.insert("store_id", _store_id);
    json.insert("station_id", _station_id);
    json.insert("operator_id", _operator_id);
    json.insert("coupon", _coupon);
    QByteArray reqData = QJsonDocument(json).toJson(QJsonDocument::Compact);
    reqData = CheckSendArray(reqData);
    
    QJsonObject retJson = SendRequest(reqData);
    int statusCode = retJson["statusCode"].toInt();
    switch (statusCode) 
    {
    case 100: //成功
        return ShowForUnConsum(retJson);
    case 11: //无效码
        return ShowForInvalid(retJson);
    case 12: //过期码
        return ShowForExpird(retJson);
    case 14: //已核销
        return ShowForHasConsum(retJson);
    default: //出错    
        return ShowForErr(retJson);
    }
}

QJsonObject FMPRedeem::SendRequest(const QByteArray &reqData)
{
    qDebug() << "send data: " << reqData;
    QJsonObject retJson;
    QNetworkAccessManager nam;
    QNetworkRequest req;
    QNetworkReply* reply = nullptr;
    
    QSslConfiguration config;
    QList<QSslCertificate> certs = QSslCertificate::fromPath(qApp->applicationDirPath() + "/client01.pem");
    config.setPeerVerifyMode(QSslSocket::VerifyNone);
    config.setProtocol(QSsl::SslV3);
    config.setCaCertificates(certs);

    req.setSslConfiguration(config);
    req.setUrl(_url);
    req.setHeader(QNetworkRequest::ContentTypeHeader, "application/json");
    req.setHeader(QNetworkRequest::ContentLengthHeader, reqData.length());
    
    reply = nam.post(req, reqData);
    
    // 使用定时器处理超时
    QEventLoop loop;
    connect(&nam, &QNetworkAccessManager::finished, &loop, &QEventLoop::quit);
    QTimer timer;
    timer.setSingleShot(true);
    connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
    timer.start(1000 * 30);
    loop.exec();
    
    if(timer.isActive())
    {
        timer.stop();
        if(reply->error() == QNetworkReply::NoError)
        {
            QByteArray respons = reply->readAll();
            retJson = QJsonDocument::fromJson(respons).object();
        }
        else
        {
            //网络错误
            retJson["statusCode"] = FM_API_NETWORKERROR;
            retJson["msg"] = reply->errorString();
        }
    }
    else
    {
        //超时
        disconnect(reply, &QNetworkReply::finished, &loop, &QEventLoop::quit);
        reply->abort();
        retJson["statusCode"] = FM_API_TIMEOUT;
        retJson["msg"] = "请求超时";
    }
    reply->deleteLater();
    return retJson;
}

QJsonObject FMPRedeem::ShowForUnConsum(QJsonObject json)
{    
    qDebug() << json;
    
    QJsonObject codeInfo = json["codeInfo"].toObject();
    QString act_name = codeInfo["act_name"].toString();
    QString code_name = codeInfo["act_id"].toString();
    QString vdata = codeInfo["vdata"].toString();
    QString coupon = codeInfo["code"].toString();
    QString ebcode = codeInfo["ebcode"].toString();
    QString time_name = QString("有效期至:    ").append(vdata);
    int couponType = json["couponType"].toInt();

    if( ConsumptionDialog::ShowForUnConsum(act_name, code_name,time_name,coupon))
    {
        _redeem_json = QJsonObject();
        _redeem_json["ver"] = 2;
        _redeem_json["clientReqCount"] = (++_clientReqCount%=10000000);
        _redeem_json["reqtype"] = 71;
        _redeem_json["partnerId"] = _partner_id;
        _redeem_json["store_id"] = _store_id;
        _redeem_json["station_id"] = _station_id;
        _redeem_json["trans_id"] = QString::number(QDateTime::currentDateTimeUtc().toTime_t());
        _redeem_json["operator_id"] = _operator_id;
        _redeem_json["business_date"] = QDate::currentDate().toString("yyyyMMdd");
    
        if( couponType == 0){ //商品券            
            QJsonObject transaction;
            QJsonArray transactions;
            transaction["code"] = coupon;
            transaction["ebcode"] = ebcode;
            
            //根据服务端返回的可适用商品信息，校验pos请求中的商品信息是否匹配
            QJsonArray redeemProducts;
            int seq = 1;
            QJsonArray posProducts = _products_info;
            QJsonArray serverProducts = SearchJsonObject(json, "products").toArray();
            for(int i = 0; i < serverProducts.size(); i++)
            {
                QJsonObject serverProduct = serverProducts[i].toObject();
                QString serverPid = SearchJsonObject(serverProduct, "pid").toString();
                int serverNum = SearchJsonObject(serverProduct, "number").toInt();
                
                for(int i = 0; i < posProducts.size(); i++)
                {
                    QJsonObject posProduct = posProducts[i].toObject();
                    QString posPid = SearchJsonObject(posProduct, "pid").toString();
                    int posNum = SearchJsonObject(posProduct, "consume_num").toInt();
                    if(posPid == serverPid)
                    {
                        QJsonObject redeemProduct;
                        redeemProduct.insert("seq", seq);
                        redeemProduct.insert("pid", posPid);
                        redeemProduct.insert("consume_num", qMin(serverNum, posNum));
                        redeemProducts.append(redeemProduct);
                        seq++;
                        break;
                    }
                }
            }
            
            if(redeemProducts.isEmpty())
            {
                //不存在对应商品
                return ShowForMismatch(json);
            }
            
            transaction["products"] = redeemProducts;
            transactions.append(transaction);
            _redeem_json["transactions"] = transactions;
        }
        if( couponType == 1){  //代金券            
            QJsonObject transaction;
            transaction["code"] = coupon;
            transaction["ebcode"] = ebcode;
    
            QJsonArray transactions;
            transactions.append(transaction);
    
            _redeem_json["transactions"] = transactions;
        }
        QByteArray reqData = QJsonDocument(_redeem_json).toJson();
        reqData = CheckSendArray(reqData);
        
        QJsonObject redeemResult;
        QJsonObject retJson = SendRequest(reqData);
        qDebug() << retJson;
        int statusCode = retJson["statusCode"].toInt();
        switch(statusCode)
        {
        case 100:
        {
            QString _time = QDateTime::currentDateTime().toString("yyyy-MM-dd");
            QString _time_name;
            _time_name.append(_store_id).append("(").append(_station_id).append( ")").append("     ").append(_time);
            ConsumOkDialog::showConsumOk( act_name, code_name, _time_name, coupon);

            QJsonArray pay_ids;
            QJsonObject pay_id;
            if(couponType == 0) //商品券
            {
                pay_id["pay_amount"] = SearchJsonObject(json, "paid").toInt();
            }
            else if(couponType == 1) //代金券
            {
                pay_id["pay_amount"] = SearchJsonObject(json, "amount").toInt();
            }
            pay_id["pay_id"] = couponType;
            pay_id["pay_str"] = act_name;
            pay_id["code"] = coupon;
            pay_id["act_id"] = code_name;
            
            pay_ids.append(pay_id);
            redeemResult["pay_ids"] = pay_ids;
            redeemResult["redeem_json"] = _redeem_json;
        }
            break;
        default:
            ErrCodeDialog::showForErr(coupon, QString("error:").append(QString::number(statusCode)));
            break;
        }
        redeemResult["statusCode"] = retJson["statusCode"];
        redeemResult["msg"] = retJson["msg"].toString();
        return redeemResult;
    }
    else
    {
        QJsonObject retJson;
        retJson["statusCode"] = FM_API_WINDOWCLOSE;
        retJson["msg"] = "窗口关闭";
        return retJson;
    }
}

QJsonObject FMPRedeem::ShowForHasConsum(QJsonObject json)
{
    QString storeInfo = QString("%1(%2)").arg(_store_id).arg(_station_id);
    ConsumptionDialog::ShowForHasConsum(json["msg"].toString(), "", storeInfo, _coupon);
    return json;
}

QJsonObject FMPRedeem::ShowForInvalid(QJsonObject json)
{
    ErrCodeDialog::showForInvalid(_coupon);
    return json;
}

QJsonObject FMPRedeem::ShowForExpird(QJsonObject json)
{
    ErrCodeDialog::showForExpird("", "", "", _coupon);
    return json;
}

QJsonObject FMPRedeem::ShowForErr(QJsonObject json)
{
    int statusCode = json["statusCode"].toInt();
    QString msg = json["msg"].toString();
    ErrCodeDialog::showForErr(_coupon, QString("%1: %2").arg(QString::number(statusCode)).arg(msg));
    return json;
}

QJsonObject FMPRedeem::ShowForMismatch(QJsonObject json)
{
    ErrCodeDialog::showForMismatch(_coupon, "券和商品不匹配");
    QJsonObject mismatch;
    mismatch["statusCode"] = 31;
    mismatch["msg"] = "券和商品不匹配";
    return mismatch;
}

QJsonObject FMPRedeem::GetRedeemJson() const
{
    return _redeem_json;
}

int FMPRedeem::ZH_caclChkValue(char *pJsonData, int startPos, int endPos)
{
    /* startPos <= && < endPos */
    int value = 0, loop = startPos, count = 0;
    for (; loop < endPos; loop++)
    {
        if( pJsonData[loop] == '"' || pJsonData[loop] == '\'')
            continue;

        if (2 > count){
            value += (int)pJsonData[loop];
        }
        else if  (2 == count){
            value *= (int)pJsonData[loop];
        }else{
            value -= (int)pJsonData[loop];
        }
        count = (count + 1) & 3;
    }
    return value;
}

QByteArray FMPRedeem::CheckSendArray(QByteArray &jsonArray)
{
    char tmpBuf[4096] = {0};

    strcpy(tmpBuf, jsonArray.data());

    int strLength = strlen(tmpBuf);

    while('}' != tmpBuf[strLength - 1])
    {
        strLength--;
    }
    strLength--;

    sprintf(tmpBuf + strLength, ", \"checkValue\":");

    int aLength = strlen(tmpBuf + strLength);

    int nValue = ZH_caclChkValue( tmpBuf, 0, strLength + 2);
    strLength += aLength;

    sprintf(tmpBuf + strLength, " %d", nValue);

    aLength = strlen(tmpBuf + strLength);

    strLength += aLength;

    tmpBuf[strLength] = '}';
    tmpBuf[strLength + 1] = '\0';
    strLength ++;

    QByteArray array(tmpBuf);

    return array;
}