#include "fmapicfg.h"

#include <Windows.h>
#include <tchar.h>
#include <fmutils/fmutils.hpp>


FMApiCfg::FMApiCfg( LPCSTR file /*= NULL*/ )
    : d_ptr(new FMApiCfgPrivate(this, file))
{

}

FMApiCfg::~FMApiCfg()
{
    FM_D(FMApiCfg);
    delete d;
}

FMApiPropMap       * FMApiCfg::GetPropsMap()
{
    FM_D(FMApiCfg);
    return &d->_prop_map;
}

const char* FMApiCfg::GetTransUrlFormat()
{
    FM_D(FMApiCfg);
    return d->_trans_url;
}

//////////////////////////////////////////////////////////////////////////
FMApiCfgPrivate::FMApiCfgPrivate(FMApiCfg *parent, LPCSTR file)
    : q_ptr(parent)
{
    GetModuleFileNameA(NULL, _file, MAX_PATH);
    LPSTR str_pos = strrchr(_file, FM_PATH_DELIM) + 1;
    strcpy(_app_name, str_pos);
    str_pos = strchr(_app_name, FM_DOT_DELIM);
    *str_pos = 0;

    if (NULL == file) {
        LPSTR str_pos = _file;
        LPSTR file_suffix = FM_CFG_SUFFIX;
        int suffix_len = strlen(file_suffix) + 1;
        str_pos = strrchr(str_pos, FM_DOT_DELIM);
        if (str_pos) {
            strcpy(str_pos, file_suffix);
        }
    } else {
        strcpy(_file, file);
    }

    InitializeCriticalSection(&_cfg_cs);
    Load();
}

FMApiCfgPrivate::~FMApiCfgPrivate()
{
    DeleteCriticalSection(&_cfg_cs);
}

VOID FMApiCfgPrivate::Load()
{
    DWORD size = GetPrivateProfileStringA(_app_name, FM_TRANS_URL, NULL, _trans_url, 1024, _file);

    char map_section[64] = { 0 };
    size = GetPrivateProfileStringA(_app_name, FM_PROPS_SECTION, NULL, map_section, 64, _file);
    if (size > 0) {
        FMAutoLock auto_lock(_cfg_cs);
        _prop_map.clear();
        ZeroMemory(_sections, 2048);
        GetPrivateProfileSectionA(map_section, _sections, 2048, _file);
        LPSTR key = _sections;
        LPSTR val = strchr(_sections, FM_EQU_DELIM);
        while(key && val) {
            *val++ = 0;
            _prop_map[key] = val;
            key = val + strlen(val) + 1;
            val = strchr(key, FM_EQU_DELIM);
        }
        if (_prop_map.size() > 0) {
            FMLOG("Properties map loaded.");
        }
        else {
            FMLOG("No property name loaded.");
        }
    }
    else {
        FMLOG("Failed reading section name of properties.");
    }
}

