﻿#ifndef FMLOGGER_H
#define FMLOGGER_H

#include "fmp_logstream.h"
#include <QObject>

class QFile;

class FMLogger : public QObject
{
    Q_OBJECT
public:
    enum {
        LOG_ERROR = 1, LOG_WARNING, LOG_INFO, LOG_DEBUG
    };
    static FMLogger *Instance();
    QIODevice *getIODevice();
    QString GetLogPath();

    ~FMLogger();

private:
    explicit FMLogger(QObject *parent = 0);
    QString _NewFileName();

    QFile *_file;
};

#define FMLOG(level, ioDevice) ((ioDevice == nullptr) ? \
    FMPNullLogStream(level, __FILE__, __FUNCTION__, __LINE__) :\
    FMPLogStream(level, __FILE__, __FUNCTION__, __LINE__, ioDevice))

#define FM_DEBUG()  FMLOG(FMLogger::LOG_DEBUG, FMLogger::Instance()->getIODevice())
#define FM_INFO()   FMLOG(FMLogger::LOG_INFO, FMLogger::Instance()->getIODevice())
#define FM_WARN()   FMLOG(FMLogger::LOG_WARNING, FMLogger::Instance()->getIODevice())
#define FM_ERROR()  FMLOG(FMLogger::LOG_ERROR, FMLogger::Instance()->getIODevice())

#endif // FMLOGGER_H
