﻿#include "fmlogger.h"
#include "fmsetting.h"
#include <QApplication>
#include <QDateTime>
#include <QFile>
#include <QDir>

FMLogger::FMLogger(QObject *parent) : QObject(parent),
    _file(nullptr)
{
}

FMLogger::~FMLogger()
{
    if(_file != nullptr) {
        _file->close();
        delete _file;
        _file = nullptr;
    }
}

FMLogger *FMLogger::Instance()
{
    static FMLogger logger;
    return &logger;
}

QIODevice *FMLogger::getIODevice()
{
    if(_file == nullptr) {
        QString fileName = _NewFileName();
        _file = new QFile(fileName);
        qDebug() << "New File: " << fileName;
        _file->open(QIODevice::Append);
    }
    return _file;
}

QString FMLogger::GetLogPath()
{
    QString path = FMSetting::GetValue("LogPath", qApp->applicationDirPath()+"/log").toString();
    path.replace("\\", "/");
    QDir log_dir;
    if (!log_dir.isAbsolutePath(path)) {
        path = qApp->applicationDirPath() + "/" + path;
    }
    return path;
}

QString FMLogger::_NewFileName()
{
    QString log_path = GetLogPath();
    QDir log_dir(log_path);
    if (!log_dir.exists()) {
        if (log_dir.mkdir(log_path)) {
            qDebug() << "Create log dir:" << log_path;
        }
        else {
            qDebug() << "Create log dir" << log_path << "failed!";
        }
    }
    QString fileName = log_path + "/" + qApp->applicationName() + "_" +QString::number(QDateTime::currentMSecsSinceEpoch()) +  ".log";
    return fileName;
}
