#include "fm_mwrf32.h"
#include "mwdll/mwrf32.h"

bool ConnectDevice(int port, int baud, int sector, const QString password, HANDLE &handle, QString &error)
{
    int st;
    handle = rf_init(port, baud);
    if((int)handle<=0)
    {
        error = "open device failed";
        return false;
    }
    st = rf_load_key_hex(handle, 0, sector, password.toLatin1().data());
    if(st!=0)
    {
        rf_exit(handle);
        error = "load key error";
        return false;
    }
    return true;
}

bool ReadCard(const HANDLE handle, int sector, QString &vipNo, QString &error)
{
    int st;
    unsigned long snr; //卡片序列号
    st = rf_card(handle, 0, &snr);
    if(st!=0)
    {
        error = "could not find the card";
        return false;
    }
    st = rf_authentication(handle, 0, sector);
    if(st!=0)
    {
        error = "check password failure";
        return false;
    }
    unsigned char rdata[32];
    ZeroMemory(rdata,32);
    st = rf_read(handle, sector*4, rdata);
    if(st!=0)
    {
        error = "read data error";
        return false;
    }
    vipNo = QString::fromLatin1((char*)rdata);
    return true;
}

void DisConnectDevice(const HANDLE handle)
{
    rf_exit(handle);
}
