#include "fmvippanel.h"
//#include "fmvipforward.h"
#include "ui_fmvippanel.h"
#include "fmvipfund.h"
#include "fmvipfund.h"

#include <QFile>


FMVipPanel::FMVipPanel(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipPanel)
{
    ui->setupUi(this);
}

FMVipPanel::~FMVipPanel()
{
    delete ui;
}

void FMVipPanel::initWnd(Session *session)
{
    this->_session = session;
    ui->operator_label->setText(session->data(PosProps.OperatorId).toString());
    ui->bd_label->setText(session->data(PosProps.BussinessDate).toString());
    ui->id_label->setText(session->data(PosProps.Fm_open_id).toString());
    ui->balance_label->setText(DOUBLE_STR(session->data(PosProps.Amount).toInt() / 100.0));
    ui->name_label->setText(session->data(PosProps.Name).toString());
    ui->bir_label->setText(session->data(PosProps.Birthday).toString());
    ui->point_label->setText(QString::number(session->data(PosProps.Score).toInt()));

    ui->fund_btn->setFocus();
}

void FMVipPanel::on_fund_btn_clicked()
{
    emit fund();
}

void FMVipPanel::on_lock_btn_clicked()
{
    emit lock();
}

void FMVipPanel::on_activate_btn_clicked()
{
    emit activate();
}
