#include "fmviplogin.h"
#include "ui_fmviplogin.h"
#include "fmvippanel.h"
#include <QFile>
#include <QMutex>
#include "fmloading.h"
#include "fmnumpad.h"

FMVipLogin::FMVipLogin(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipLogin)
{
    numpad = NULL;
    ui->setupUi(this);
    connect(this, &FMVipLogin::startreader, &m_reader, &Reader::readVipNO);
    connect(&m_reader, &Reader::getVipNO, this, &FMVipLogin::readVipNO);
    emit startreader();
    ui->login_edit->setFocus();
    qDebug() <<  "main:" <<QThread::currentThreadId();
}

FMVipLogin::~FMVipLogin()
{
    qDebug() << "des FMVipLogin";
    m_reader.disconnectReader();
    delete ui;
    if(numpad != NULL)
    {
        delete numpad;
        numpad = NULL;
    }
}

void FMVipLogin::onstartreader()
{
    emit startreader();
}

void FMVipLogin::readVipNO(QString VipNo)
{
    ui->login_edit->setText(VipNo);

    QString id = VipNo;

    _session->addData(PosProps.Member_sign, id);

    this->setEnabled(false);

    setIsBusy(true);

    emit login();
}

void FMVipLogin::initWnd(Session *session)
{
    this->_session = session;
    QString version_info = getVersionInfo();
    ui->version_lable->setText(version_info);

    QString placeText;
    if(session->data(PosProps.FM_Type).toInt() == FM_Pay) {
        placeText = "输入支付码";
    } else {
        placeText = "输入手机号/会员码/支付码";
    }
    ui->operator_label->setText(session->data(PosProps.OperatorId).toString());
    ui->bd_label->setText(session->data(PosProps.BussinessDate).toString());
    ui->login_edit->setPlaceholderText(placeText);
}

QString FMVipLogin::getVersionInfo()
{
    QByteArray versionInfo;
    QFile versionFile(qApp->applicationDirPath() + "/version.dat");
    bool isOk = versionFile.open(QIODevice::ReadOnly);
    if(isOk) {
        versionInfo = versionFile.readAll();
    } else {
        versionInfo = "未知";
    }
    versionFile.close();
    return versionInfo;
}

void FMVipLogin::on_login_btn_clicked()
{
    QString id = ui->login_edit->text();

    _session->addData(PosProps.Member_sign, id);

    this->setEnabled(false);

    setIsBusy(true);

    emit login();
}

void FMVipLogin::resetWnd()
{
    this->setEnabled(true);
    ui->login_edit->clear();
    ui->login_edit->setFocus();
}

void FMVipLogin::on_login_key_clicked()
{
    if(numpad == NULL)
    {
        numpad = new FMNumPad();
        connect(numpad, &FMNumPad::finished, this, &FMVipLogin::on_clean_numpad);
        connect(numpad, &FMNumPad::digit_click, this, &FMVipLogin::on_edit_change);
        connect(numpad, &FMNumPad::digit_delete, this, &FMVipLogin::on_delete_clicked);
        connect(numpad, &FMNumPad::digit_clear, this, &FMVipLogin::on_clear_clicked);
        connect(numpad, &FMNumPad::digit_confirm, this, &FMVipLogin::on_confirm_clicked);
    }
    numpad->show();
    numpad->setGeometry(x() + (width()+640)/2, numpad->y(), numpad->width(), numpad->height());
}

void FMVipLogin::on_edit_change(QString numkey)
{
     ui->login_edit->setText(ui->login_edit->text() + numkey);
}

void FMVipLogin::on_delete_clicked()
{
    int length = ui->login_edit->text().size();
    if(length <= 1)
        ui->login_edit->setText(QString(""));
    else
        ui->login_edit->setText(ui->login_edit->text().left(length - 1));
}

void FMVipLogin::on_clear_clicked()
{
    ui->login_edit->setText(QString(""));
}
void FMVipLogin::on_confirm_clicked()
{
    on_login_btn_clicked();
}

void FMVipLogin::on_clean_numpad()
{
    if(numpad != NULL)
    {
        delete numpad;
        numpad = NULL;
    }
}
