#ifndef FMMSGWND_H
#define FMMSGWND_H

#include "fmvipwnd.h"

namespace Ui {
class FMMsgWnd;
}

class FMMsgWnd : public FMVipWnd
{
    Q_OBJECT

public:
    explicit FMMsgWnd(FMVipWnd *parent = 0);
    ~FMMsgWnd();

    enum InfoType
    {
        T_Normal,
        T_Success,
        T_Failure,
        T_Warning,
        T_LoginSuccess
    };

    void show(InfoType type = T_Normal, const QString &info = "");
    static void FailureWnd(const QString &info);
    static void WarningWnd(const QString &info);
    static void SuccessWnd(const QString &info);
    static void LoginSuccess(const QString &account, const QString &name, const QString &birthday);

private slots:
    void on_alertBtnOk_clicked();

private:
    Ui::FMMsgWnd *ui;
};

#endif // FMMSGWND_H
