#include "fmcouponwidget.h"
#include "ui_fmcouponwidget.h"
#include <QPainter>

FMCouponWidget::FMCouponWidget(Coupon conpon, QWidget *parent) :
    QWidget(parent),
    ui(new Ui::FMCouponWidget)
{
    ui->setupUi(this);
    ui->code_lab->setText(conpon.code);
    ui->amount_lab->setText(QString::number(conpon.disAmount, 'f', 2));
    ui->desc_lab->setText(conpon.desc);
}

FMCouponWidget::~FMCouponWidget()
{
    delete ui;
}

void FMCouponWidget::paintEvent(QPaintEvent *event)
{
    Q_UNUSED(event);
    QStyleOption  opt;
    opt.init(this);
    QPainter  p(this);
    style()->drawPrimitive(QStyle::PE_Widget, &opt, &p, this);
}
