#include "taskpay.h"
#include "fmviporder.h"
#include "tasklogin.h"
#include "taskothers.h"

TaskPay::TaskPay(QJsonObject &jsonObj, QObject *parent)
    :FMTask(jsonObj, FM_Pay, 0, parent)
{
    posReqJsonObj[PosProps.TransId] = createTransId();
}

QByteArray TaskPay::doTask()
{
    preTask = new TaskLogin(posReqJsonObj, _session, this);
    preTask->session()->addData(PosProps.FM_Type, FM_Pay);
    QByteArray loginRst = preTask->doTask();
    if(preTask->error() != FM_API_SUCCESS) {
        return loginRst;
    }
    this->_session = preTask->session();

    TaskCouponThread couponThread(posReqJsonObj, _session, this);
    couponThread.start();
    connect(&couponThread, SIGNAL(finished(Session*)), SLOT(onGetCoupons(Session*)));
    return FMTask::doTask();
}

void TaskPay::onGetCoupons(Session* session)
{
    _session->addData(PosProps.CouponMap, session->getCouponMap(PosProps.CouponMap));
    if(_window != nullptr) {
        qobject_cast<FMVipOrder*>(_window)->initCouponItems();
        _window->setIsBusy(false);
        _window->setEnabled(true);
    }
}

void TaskPay::setWindow()
{
    _window = new FMVipOrder;
    _window->setIsBusy();
    _window->setEnabled(false);

    for (QString prop : {PosProps.OrderAmount, PosProps.PaidAmount, PosProps.StandardAmount}) {
        session()->addData(prop, getPosJsonValue(prop).toInt());
    }

    connect(qobject_cast<FMVipOrder*>(_window), SIGNAL(pay()), this, SLOT(onPay()));
}

void TaskPay::packageServerReq()
{
    QJsonObject transObj;
    transObj[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();
    transObj[ServerProps(PosProps.CodeAmount)] = session()->data(PosProps.CodeAmount).toInt();
    transObj[ServerProps(PosProps.IsUseScore)] = session()->data(ServerProps(PosProps.IsUseScore)).toInt();

    QJsonArray couponArr;
    for (auto code : session()->data(PosProps.CouponMap).toMap().keys())
    {
        couponArr.append(code);
    }
    transObj[ServerProps(PosProps.Coupons)] = couponArr;

    serverReqJsonObj[ServerProps(PosProps.Transaction)] = transObj;
    serverReqJsonObj[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);
}

void TaskPay::packagePOSRsp()
{
    for (QString prop : {PosProps.StatusCode, PosProps.Msg, PosProps.Fm_id}) {
        posRspJsonObj[prop] = getServerJsonValue(prop);
    }
    posRspJsonObj[PosProps.Prompt] = 1;
    posRspJsonObj[PosProps.Fm_open_id] = session()->data(PosProps.Fm_open_id).toString();

    int paidTotalAmount = 0;

    QJsonArray pay_ids;
    QJsonObject pay_id;
    pay_id[PosProps.Pay_id] = "24";
    pay_id[PosProps.Pay_str] = "会员储值金支付";
    int codeAmount = getServerJsonValue(PosProps.CodeAmount).toInt();
    pay_id[PosProps.Paid_total_amount] = codeAmount;
    paidTotalAmount += codeAmount;
    pay_ids.append(pay_id);

    pay_id[PosProps.Pay_id] = "25";
    pay_id[PosProps.Pay_str] = "会员积分支付";
    int scoreAmount = getServerJsonValue(PosProps.ScoreAmount).toInt();
    pay_id[PosProps.Paid_total_amount] = scoreAmount;
    paidTotalAmount += scoreAmount;
    pay_ids.append(pay_id);

    for(auto coupon : getServerJsonValue(PosProps.Coupons).toArray()) {
        QJsonObject cp = coupon.toObject();
        pay_id[PosProps.Pay_id] = "77";
        pay_id[PosProps.Pay_str] = "代金券支付";
        int couponAmount = cp[ServerProps(PosProps.Coupon_disAmount)].toInt();
        pay_id[PosProps.Paid_total_amount] = couponAmount;
        paidTotalAmount += couponAmount;
        pay_id[PosProps.Coupon_code] = cp[ServerProps(PosProps.Coupon_code)];
        pay_ids.append(pay_id);
    }
    posRspJsonObj[PosProps.Pay_ids] = pay_ids;
    posRspJsonObj["total_amount"] = session()->data(PosProps.OrderAmount).toInt();
    posRspJsonObj[PosProps.Paid_total_amount] = paidTotalAmount;
    posRspJsonObj["invoice_amount"] = paidTotalAmount;
    posRspJsonObj["incentives_amount"] = 0;
    posRspJsonObj["forward"] = posReqJsonObj["forward"];
}

void TaskPay::onPay()
{
    sendToServer();
    closeWindow();
}

//TaskPay::TaskCouponThread::TaskCouponThread(QJsonObject &jsonObj, Session *session, QObject *parent):
//    _session(session),
//    QThread(parent)
//{
//    task = new TaskCoupon(jsonObj, session, parent);
//}

//void TaskPay::TaskCouponThread::run()
//{
//    task->doTask();
//    _session = task->session();
//}
